/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.ies.handler;

import com.fold1.eulumdat.tools.ProjectStateManager;
import com.fold1.eulumdat.tools.ies.IesValidatorLogger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddRemoveIesNatureHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IProject project = null;
            if (element instanceof IProject) {
                project = (IProject)element;
            } else if (element instanceof IAdaptable) {
                project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
            }
            if (project != null) {
                try {
                    AddRemoveIesNatureHandler.toggleNature(project);
                }
                catch (CoreException e) {
                    IesValidatorLogger.logError("Problem with toggling nature", e);
                    throw new ExecutionException("Failed to toggle nature", (Throwable)e);
                }
            }
            ++n2;
        }
        return null;
    }

    public static void toggleNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if ("com.fold1.eulumdat.tools.ies.iesValidatorNature".equals(natures[i])) {
                project.deleteMarkers("com.fold1.eulumdat.tools.ies.iesProblem", true, 2);
                String[] newNatures = new String[natures.length - 1];
                System.arraycopy(natures, 0, newNatures, 0, i);
                System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "com.fold1.eulumdat.tools.ies.iesValidatorNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
        ProjectStateManager.getInstance().addNature("com.fold1.eulumdat.tools.ies.iesValidatorNature");
    }
}

