/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.ies.checker;

import com.fold1.errors.IProblemReporter;
import com.fold1.eulumdat.tools.ies.IesValidatorLogger;
import com.fold1.ies.parser4.IESErrorListener;
import com.fold1.ies.parser4.IESLexer;
import com.fold1.ies.parser4.IESParser;
import com.fold1.ies.parser4.IESValidatorParseListener;
import com.fold1.ies.parser4.IESValidatorVisitor;
import com.fold1.util.EncodingUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class IESChecker4 {
    private static final boolean STRICT = Boolean.getBoolean("ies.parser.strict");
    private static IFile iesfile;
    private static IProblemReporter reporter;

    public static void check(final IFile iesfile1, IProblemReporter reporter1) {
        iesfile = iesfile1;
        reporter = reporter1;
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                IesValidatorLogger.logInfo("IES validation using parser2024 : " + iesfile.getProject().getName() + " /../" + iesfile.getName());
                IESChecker4.internalRun();
            }

            public void handleException(Throwable e) {
                IesValidatorLogger.logError("Error in IES validation " + iesfile1.getName() + ":" + e.getMessage(), e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void internalRun() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(iesfile.getContents());
                try {
                    block21: {
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, EncodingUtils.guessCharEncoding((BufferedInputStream)bufferedInputStream, (String)iesfile.getName()));
                        try {
                            try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                                CodePointCharStream input = CharStreams.fromReader((Reader)reader);
                                IESLexer lexer = new IESLexer((CharStream)input);
                                lexer.setErrorReporter(reporter);
                                lexer.setFilename(iesfile.getProjectRelativePath().toString());
                                lexer.strictNumbers = STRICT;
                                String filename = iesfile.getProjectRelativePath().toString();
                                IESErrorListener errorListener = new IESErrorListener(reporter, filename);
                                lexer.addErrorListener((ANTLRErrorListener)errorListener);
                                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                                IESParser parser = new IESParser((TokenStream)tokens);
                                parser.removeErrorListeners();
                                parser.setErrorReporter(reporter);
                                parser.setFilename(iesfile.getProjectRelativePath().toString());
                                parser.strictNumbers = STRICT;
                                parser.addErrorListener((ANTLRErrorListener)errorListener);
                                parser.addParseListener((ParseTreeListener)new IESValidatorParseListener(reporter, filename));
                                IESParser.IesContext tree = parser.ies();
                                IesValidatorLogger.logInfo(tree.toStringTree((Parser)parser));
                                IESValidatorVisitor visitor = new IESValidatorVisitor();
                                visitor.visit((ParseTree)tree);
                            }
                            if (inputStreamReader == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStreamReader == null) throw throwable;
                            inputStreamReader.close();
                            throw throwable;
                        }
                        inputStreamReader.close();
                    }
                    if (bufferedInputStream == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (bufferedInputStream == null) throw throwable;
                    bufferedInputStream.close();
                    throw throwable;
                }
                bufferedInputStream.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (RecognitionException | CoreException e) {
            IesValidatorLogger.logError("Error in IES validation " + iesfile.getName() + ":" + e.getMessage(), e);
            return;
        }
        catch (IOException e1) {
            IesValidatorLogger.logError("Error in opening IES " + iesfile.getName() + ":" + e1.getMessage(), e1);
        }
    }
}

