/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.ies.checker;

import com.fold1.errors.IProblemReporter;
import com.fold1.eulumdat.tools.ies.IesValidatorLogger;
import com.fold1.ies.parser.IESLexer;
import com.fold1.ies.parser.IESParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class IESChecker {
    private static final String ERROR_IN_IES_VALIDATION = "Error in IES validation ";
    private static IFile iesfile;
    private static IProblemReporter reporter;
    private static final int[] BYTE_ORDER_MARK;

    static {
        BYTE_ORDER_MARK = new int[]{239, 187, 191};
    }

    public static void check(final IFile iesfile1, IProblemReporter reporter1) {
        iesfile = iesfile1;
        reporter = reporter1;
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                IesValidatorLogger.logInfo("IES validation using parser2014");
                IESChecker.internalRun();
            }

            public void handleException(Throwable e) {
                IesValidatorLogger.logError(IESChecker.ERROR_IN_IES_VALIDATION + iesfile1.getName() + ":" + e.getMessage(), e);
            }
        });
    }

    private static void internalRun() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream contents = new BufferedInputStream(iesfile.getContents());){
                ((InputStream)contents).mark(BYTE_ORDER_MARK.length);
                int[] firstFewBytes = new int[BYTE_ORDER_MARK.length];
                int index = 0;
                while (index < BYTE_ORDER_MARK.length) {
                    firstFewBytes[index] = ((InputStream)contents).read();
                    ++index;
                }
                boolean header = Arrays.equals(firstFewBytes, BYTE_ORDER_MARK);
                if (header) {
                    reporter.report(iesfile.getProjectRelativePath().toString(), "The file contains a UTF-8 BOM header and may fail with photometric programs", 0, 0, 3, 2, IESChecker.class.getName(), null);
                }
                ((InputStream)contents).reset();
                ANTLRInputStream input = new ANTLRInputStream((InputStream)contents);
                IESLexer lexer = new IESLexer((CharStream)input);
                lexer.setErrorReporter(reporter);
                lexer.setFilename(iesfile.getProjectRelativePath().toString());
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                IESParser parser = new IESParser((TokenStream)tokens);
                parser.setErrorReporter(reporter);
                parser.setFilename(iesfile.getProjectRelativePath().toString());
                parser.rule();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            IesValidatorLogger.logError("Error in opening IES " + iesfile.getName() + ":" + e1.getMessage(), e1);
        }
        catch (RecognitionException | CoreException e1) {
            IesValidatorLogger.logError(ERROR_IN_IES_VALIDATION + iesfile.getName() + ":" + e1.getMessage(), e1);
        }
    }
}

