/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.ies.builder;

import com.fold1.data.IesData;
import com.fold1.data.IesFactory;
import com.fold1.errors.IProblemReporter;
import com.fold1.eulumdat.tools.decorators.AbstractEulumdatDecorator;
import com.fold1.eulumdat.tools.decorators.ProblemDecorator;
import com.fold1.eulumdat.tools.ies.IesValidatorLogger;
import com.fold1.eulumdat.tools.ies.checker.IESChecker;
import com.fold1.eulumdat.tools.ies.checker.IESChecker4;
import com.fold1.eulumdat.tools.ies.preferences.ValidatorPreferencePage;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import com.fold1.eulumdat.tools.utils.BuilderUtils;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.validator.visitor.CountingResourceVisitor;
import com.fold1.eulumdat.tools.validator.visitor.CountingTester;
import com.fold1.exceptions.ParserException;
import com.fold1.util.Stopwatch;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class IesValidatorBuilder
extends IncrementalProjectBuilder {
    private static final boolean ANTLR4 = Boolean.getBoolean("ies.parser.new");
    public static final String BUILDER_ID = "com.fold1.eulumdat.tools.ies.iesValidatorBuilder";
    public static final String CHECK = "check";
    public static final String EXPECTED = "expected";
    public static final String FOUND = "found";
    public static final String MARKER_TYPE = "com.fold1.eulumdat.tools.ies.iesProblem";
    private CountingTester iesCounterTester;
    private IProgressMonitor progress = new NullProgressMonitor();

    private static void cleanIES(IResource resource) {
        IFile file = null;
        if (resource instanceof IFile) {
            file = (IFile)resource;
            BuilderUtils.deleteMarkers((IResource)file, (String)MARKER_TYPE);
            AbstractEulumdatDecorator.refresh((AbstractEulumdatDecorator)ProblemDecorator.getDecoratorInstance(), (IResource)file);
        }
    }

    private static void addMarker(IFile file, String message, int lineNumber, int charStart, int charEnd, int severity, String check, Object expected) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            marker.setAttribute(CHECK, (Object)check);
            if (charStart < 0 && charEnd < 0 && lineNumber >= 0) {
                marker.setAttribute("lineNumber", lineNumber);
            } else {
                if (charStart >= 0) {
                    marker.setAttribute("charStart", charStart);
                }
                if (charEnd >= 0) {
                    marker.setAttribute("charEnd", charEnd);
                }
            }
            if (expected != null) {
                if (expected instanceof Map) {
                    Map attributes = (Map)expected;
                    marker.setAttributes(attributes);
                }
                if (expected instanceof String || expected instanceof Boolean || expected instanceof Integer) {
                    marker.setAttribute(EXPECTED, expected);
                } else {
                    marker.setAttribute(EXPECTED, (Object)expected.toString());
                }
            }
        }
        catch (CoreException e) {
            Logger.logError((String)("Problem creating marker in " + file.getName()), (Throwable)e);
        }
    }

    public IesValidatorBuilder() {
        this.iesCounterTester = r -> Utils.isIES((String)r.getName());
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        try {
            try {
                this.progress = monitor;
                CountingResourceVisitor counter = new CountingResourceVisitor(monitor, this.iesCounterTester);
                this.getProject().accept((IResourceProxyVisitor)counter, 0);
                int count = counter.getCount();
                this.progress.beginTask("Validating IES files", count);
                this.getProject().accept((IResourceVisitor)new BuildResourceVisitor());
            }
            catch (CoreException e) {
                IesValidatorLogger.logError("Problem doing full IES build on '" + this.getProject().getName() + "'", e);
                stopwatch.stop();
                String message = "Completed full IES build of '" + this.getProject().getName() + "' in " + stopwatch.getElapsed();
                IesValidatorLogger.logInfo(message);
                this.progress.done();
            }
        }
        finally {
            stopwatch.stop();
            String message = "Completed full IES build of '" + this.getProject().getName() + "' in " + stopwatch.getElapsed();
            IesValidatorLogger.logInfo(message);
            this.progress.done();
        }
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        return this.getProject();
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        try {
            try {
                this.progress = monitor;
                int count = delta.getAffectedChildren().length;
                this.progress.beginTask("Validating IES files", count);
                delta.accept((IResourceDeltaVisitor)new BuildDeltaVisitor());
            }
            catch (CoreException e) {
                IesValidatorLogger.logError("Problem doing incremental IES build on '" + this.getProject().getName() + "'", e);
                this.progress.done();
                stopwatch.stop();
                IesValidatorLogger.logInfo("Completed incremental IES build of '" + this.getProject().getName() + "' in " + stopwatch.getElapsed());
            }
        }
        finally {
            this.progress.done();
            stopwatch.stop();
            IesValidatorLogger.logInfo("Completed incremental IES build of '" + this.getProject().getName() + "' in " + stopwatch.getElapsed());
        }
    }

    private void processIES(IResource resource) {
        if (!Utils.isIES((IResource)resource)) {
            return;
        }
        IesValidatorBuilder.cleanIES(resource);
        IFile iesfile = (IFile)resource;
        AbstractEulumdatDecorator.refresh((AbstractEulumdatDecorator)ProblemDecorator.getDecoratorInstance(), (IResource)iesfile);
        EulumdatToolsPreferences.getInstance();
        String parserPref = EulumdatToolsPreferences.getStore().getString(ValidatorPreferencePage.ID + ".parser");
        if (ANTLR4 || parserPref.equalsIgnoreCase("parser2024")) {
            IESChecker4.check(iesfile, new IESProblemReporter(iesfile));
        } else {
            IESChecker.check(iesfile, new IESProblemReporter(iesfile));
        }
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (InputStream contents = iesfile.getContents();){
                IesData iesData = IesFactory.iesDataFromStream((InputStream)contents, (String)iesfile.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ParserException e) {
            IesValidatorBuilder.addMarker(iesfile, e.getMessage(), e.getLineNumber() + 1, -1, -1, 2, null, null);
        }
        catch (IOException e) {
            IesValidatorLogger.logError("IO Problem parsing Eulumdat: " + e.getMessage(), e);
        }
        catch (CoreException e) {
            IesValidatorLogger.log(e.getStatus());
        }
    }

    class BuildDeltaVisitor
    implements IResourceDeltaVisitor {
        BuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (IesValidatorBuilder.this.progress.isCanceled() || IesValidatorBuilder.this.isInterrupted()) {
                return false;
            }
            IResource resource = delta.getResource();
            if (!(resource instanceof IFile)) {
                return true;
            }
            switch (delta.getKind()) {
                case 1: {
                    IesValidatorBuilder.this.progress.subTask(resource.getName());
                    IesValidatorBuilder.this.processIES(resource);
                    IesValidatorBuilder.this.progress.worked(1);
                    break;
                }
                case 4: {
                    IesValidatorBuilder.this.progress.subTask(resource.getName());
                    int flags = delta.getFlags();
                    if ((flags & 0x100) == 0 && (flags & 0x40000) == 0) break;
                    IesValidatorBuilder.this.processIES(resource);
                    IesValidatorBuilder.this.progress.worked(1);
                    break;
                }
                case 2: {
                    break;
                }
            }
            return false;
        }
    }

    class BuildResourceVisitor
    implements IResourceVisitor {
        BuildResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            if (IesValidatorBuilder.this.progress.isCanceled() || IesValidatorBuilder.this.isInterrupted()) {
                return false;
            }
            if (!(resource instanceof IFile)) {
                return true;
            }
            IesValidatorBuilder.this.progress.subTask(" checking " + resource.getName());
            IesValidatorBuilder.this.processIES(resource);
            IesValidatorBuilder.this.progress.worked(1);
            return false;
        }
    }

    class CleanResourceVisitor
    implements IResourceVisitor {
        CleanResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            if (IesValidatorBuilder.this.progress.isCanceled()) {
                return false;
            }
            if (!(resource instanceof IFile)) {
                return true;
            }
            IesValidatorBuilder.cleanIES(resource);
            IesValidatorBuilder.this.progress.worked(1);
            return false;
        }
    }

    class ContainsResourceVisitor
    implements IResourceDeltaVisitor {
        private boolean lamplist = false;
        private final String match;

        ContainsResourceVisitor(String match) {
            this.match = match;
        }

        public boolean isLamplist() {
            return this.lamplist;
        }

        public boolean visit(IResourceDelta resource) {
            if (IesValidatorBuilder.this.progress.isCanceled() || IesValidatorBuilder.this.isInterrupted()) {
                return false;
            }
            if (resource != null && resource.getResource() instanceof IFile) {
                IFile file = (IFile)resource.getResource();
                if (file.getName().equals(this.match)) {
                    this.lamplist = true;
                }
                return false;
            }
            return true;
        }
    }

    class IESProblemReporter
    implements IProblemReporter {
        IFile myfile;

        public IESProblemReporter(IFile myfile) {
            this.myfile = myfile;
        }

        public void report(String fname, String message, int lineNumber, int charStart, int charEnd, int severity, String check, Object expected) {
            Path path = new Path(fname);
            IFile file = IesValidatorBuilder.this.getProject().getFile((IPath)path);
            IesValidatorBuilder.addMarker(file == null ? this.myfile : file, message, lineNumber, charStart, charEnd, severity, check, expected);
        }
    }
}

