/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.visitor;

import com.fold1.data.Eulumdat2;
import com.fold1.eulumdat.tools.validator.visitor.AbstractEulumdatQuickFixVisitor;
import com.fold1.util.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReplaceProductCodeVisitor
extends AbstractEulumdatQuickFixVisitor {
    private static final String ERROR_WHILE_REPLACING_PRODUCTCODE = "Error while replacing Product Code {line 10) with ";
    private final ReplaceWith alternative;

    public ReplaceProductCodeVisitor(ReplaceWith alternative, IProgressMonitor monitor) {
        super(monitor);
        this.alternative = alternative;
    }

    @Override
    public Eulumdat2 applyVisitFix(Eulumdat2 eu) {
        switch (this.alternative) {
            case Filename: {
                eu.setProductCode(StringUtils.unquote((String)eu.getFileName()));
                break;
            }
            case Productname: {
                eu.setProductCode(StringUtils.unquote((String)eu.getProductName()));
            }
        }
        return eu;
    }

    @Override
    public String getErrorMessage() {
        return ERROR_WHILE_REPLACING_PRODUCTCODE + String.valueOf((Object)this.alternative);
    }

    public static enum ReplaceWith {
        Filename,
        Productname;

    }
}

