/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.visitor;

import com.fold1.data.Eulumdat2;
import com.fold1.eulumdat.tools.validator.visitor.AbstractEulumdatQuickFixVisitor;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.runtime.IProgressMonitor;

@ThreadSafe
public class ReplaceLampTypeVisitor
extends AbstractEulumdatQuickFixVisitor {
    private static final String ERROR_WHILE_CHANGING_LAMPTYPE = "Error while renaming lamp type ";
    private final int index;
    private final String newLamp;

    public ReplaceLampTypeVisitor(String newLamp, int index, IProgressMonitor monitor) {
        super(monitor);
        this.index = index;
        this.newLamp = newLamp;
    }

    @Override
    public Eulumdat2 applyVisitFix(Eulumdat2 eu) {
        eu.getLampSet(this.index).setType(this.newLamp);
        return eu;
    }

    @Override
    public String getErrorMessage() {
        return ERROR_WHILE_CHANGING_LAMPTYPE + this.newLamp;
    }

    @Override
    public String getProgressMessage() {
        return "Changing to '" + this.newLamp + "' in " + this.getFile().getName();
    }
}

