/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.visitor;

import com.fold1.data.Eulumdat2;
import com.fold1.data.EulumdatFactory;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.exceptions.ParserException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractEulumdatQuickFixVisitor
implements IResourceVisitor {
    protected final IProgressMonitor monitor;
    private IFile file;

    public AbstractEulumdatQuickFixVisitor(IProgressMonitor monitor2) {
        this.monitor = monitor2;
    }

    public abstract Eulumdat2 applyVisitFix(Eulumdat2 var1);

    public abstract String getErrorMessage();

    public IFile getFile() {
        return this.file;
    }

    public String getProgressMessage() {
        return "Changing " + this.getFile().getName();
    }

    public final boolean visit(IResource resource) throws CoreException {
        if (Utils.isEulumdat((IResource)resource)) {
            this.file = (IFile)resource;
            if (this.monitor != null) {
                this.monitor.subTask(this.getProgressMessage());
            }
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (BufferedInputStream contents = new BufferedInputStream(this.getFile().getContents());){
                    Eulumdat2 eu = EulumdatFactory.eulumdatFromInputStream((InputStream)contents, (String)this.getFile().getName());
                    ((InputStream)contents).close();
                    eu = this.applyVisitFix(eu);
                    ByteArrayInputStream source = new ByteArrayInputStream(eu.toString().getBytes("UTF-8"));
                    this.getFile().setContents((InputStream)source, true, true, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ParserException | IOException e) {
                throw new CoreException(EulumdatValidatorLogger.createStatus(4, 0, this.getErrorMessage(), e));
            }
            return false;
        }
        return !(resource instanceof IFile);
    }
}

