/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.fixer.AbstractEulumdatBackgroundProblemFixer;
import com.fold1.eulumdat.tools.validator.visitor.ReplaceProductCodeVisitor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReplaceProductCodeWithAlternative
extends AbstractEulumdatBackgroundProblemFixer {
    private final IMarker originalMarker;
    private final ReplaceProductCodeVisitor.ReplaceWith alternative;

    public ReplaceProductCodeWithAlternative(IMarker marker, ReplaceProductCodeVisitor.ReplaceWith alternative) {
        this.originalMarker = marker;
        this.alternative = alternative;
    }

    @Override
    protected void fixTheProblem(IMarker m, IProgressMonitor monitor) {
        try {
            m.getResource().accept((IResourceVisitor)new ReplaceProductCodeVisitor(this.alternative, monitor));
        }
        catch (CoreException e) {
            EulumdatValidatorLogger.logError(e);
        }
    }

    public String getLabel() {
        return "Replace Product Code (line 10) with " + String.valueOf((Object)this.alternative) + " field.";
    }

    @Override
    protected boolean isValidOther(IMarker markerToCheck) {
        boolean valid;
        if (markerToCheck.equals((Object)this.originalMarker)) {
            return false;
        }
        try {
            valid = ReplaceProductCodeWithAlternative.getCheckerName(this.originalMarker).equals(ReplaceProductCodeWithAlternative.getCheckerName(markerToCheck)) && this.originalMarker.getAttribute("message").equals(markerToCheck.getAttribute("message"));
        }
        catch (CoreException e) {
            return false;
        }
        return valid;
    }
}

