/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.fixer.AbstractEulumdatBackgroundProblemFixer;
import com.fold1.eulumdat.tools.validator.visitor.ReplaceDownwardFluxPercentVisitor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ReplaceDownWardFluxPercent
extends AbstractEulumdatBackgroundProblemFixer {
    private final IMarker originalMarker;

    public ReplaceDownWardFluxPercent(IMarker marker) {
        this.originalMarker = marker;
    }

    @Deprecated
    protected void fixTheProblem(IMarker marker) {
        this.fixTheProblem(marker, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    protected void fixTheProblem(IMarker marker, IProgressMonitor monitor) {
        try {
            double dfp = Double.parseDouble(marker.getAttribute("expected", "ATTRIBUTE NOT FOUND_ATTR"));
            marker.getResource().accept((IResourceVisitor)new ReplaceDownwardFluxPercentVisitor(dfp, monitor));
        }
        catch (NumberFormatException | CoreException e) {
            EulumdatValidatorLogger.logError(e);
        }
    }

    public String getLabel() {
        double dfp = Double.parseDouble(this.originalMarker.getAttribute("expected", "ATTRIBUTE NOT FOUND_ATTR"));
        return "Replace downward Flux Percentage with calculated value : " + dfp;
    }

    @Override
    protected boolean isValidOther(IMarker markerToCheck) {
        if (markerToCheck.equals((Object)this.originalMarker)) {
            return false;
        }
        if (!this.fullVersion && !markerToCheck.getResource().equals((Object)this.originalMarker.getResource())) {
            return false;
        }
        if (!markerToCheck.getResource().isAccessible()) {
            return false;
        }
        String checkerName = "com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.downflux";
        return checkerName.equals(ReplaceDownWardFluxPercent.getCheckerName(markerToCheck));
    }
}

