/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.fixer.AbstractEulumdatBackgroundProblemFixer;
import com.fold1.eulumdat.tools.validator.visitor.ReplaceDFFVisitor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ReplaceDFF
extends AbstractEulumdatBackgroundProblemFixer {
    private final IMarker originalMarker;

    public ReplaceDFF(IMarker marker) {
        this.originalMarker = marker;
    }

    @Deprecated
    protected void fixTheProblem(IMarker marker) {
        this.fixTheProblem(marker, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    protected void fixTheProblem(IMarker marker, IProgressMonitor monitor) {
        try {
            double dff = Double.parseDouble(marker.getAttribute("expected", "ATTRIBUTE NOT FOUND_ATTR"));
            int index = Integer.parseInt(marker.getAttribute("index", "ATTRIBUTE NOT FOUND_ATTR"));
            marker.getResource().accept((IResourceVisitor)new ReplaceDFFVisitor(dff, index, monitor));
        }
        catch (NumberFormatException | CoreException e) {
            EulumdatValidatorLogger.logError(e);
        }
    }

    public String getLabel() {
        double dff = Double.parseDouble(this.originalMarker.getAttribute("expected", "ATTRIBUTE NOT FOUND_ATTR"));
        int index = Integer.parseInt(this.originalMarker.getAttribute("index", "ATTRIBUTE NOT FOUND_ATTR"));
        return "Replace DFF[" + index + "] with calculated value : " + dff + " ( and similar)";
    }

    @Override
    public boolean isValidOther(IMarker markerToCheck) {
        if (markerToCheck.equals((Object)this.originalMarker)) {
            return false;
        }
        if (!this.fullVersion && !markerToCheck.getResource().equals((Object)this.originalMarker.getResource())) {
            return false;
        }
        if (!markerToCheck.getResource().isAccessible()) {
            return false;
        }
        String checkerName = "com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.values";
        return checkerName.equals(ReplaceDFF.getCheckerName(markerToCheck));
    }
}

