/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.fixer.AbstractEulumdatBackgroundProblemFixer;
import com.fold1.eulumdat.tools.validator.visitor.OverwriteProductCodeVisitor;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class OverwriteProductCodeWithPattern
extends AbstractEulumdatBackgroundProblemFixer {
    private final IMarker originalMarker;
    private final String pattern;

    public OverwriteProductCodeWithPattern(IMarker marker) {
        this.originalMarker = marker;
        this.pattern = marker.getAttribute("expected", "");
        Boolean isPlainString = Pattern.compile(this.pattern).matcher(this.pattern).matches();
        if (isPlainString.booleanValue()) {
            EulumdatValidatorLogger.logInfo("Detected plain string '" + this.pattern + "'");
        }
    }

    @Override
    protected void fixTheProblem(IMarker m, IProgressMonitor monitor) {
        try {
            String productCode = (String)m.getAttribute("expected");
            m.getResource().accept((IResourceVisitor)new OverwriteProductCodeVisitor(productCode, monitor));
        }
        catch (CoreException e) {
            EulumdatValidatorLogger.logError(e);
        }
    }

    public String getLabel() {
        return "Replace Product Code (line 10) with pattern '" + this.pattern + "'";
    }

    @Override
    protected boolean isValidOther(IMarker markerToCheck) {
        boolean valid;
        if (markerToCheck.equals((Object)this.originalMarker)) {
            return false;
        }
        try {
            valid = OverwriteProductCodeWithPattern.getCheckerName(this.originalMarker).equals(OverwriteProductCodeWithPattern.getCheckerName(markerToCheck)) && this.originalMarker.getAttribute("message").equals(markerToCheck.getAttribute("message"));
        }
        catch (CoreException e) {
            return false;
        }
        return valid;
    }
}

