/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.eulumdat.tools.lamps.ILampVerifier;
import com.fold1.eulumdat.tools.lamps.LampManagerPool;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.fixer.AbstractEulumdatBackgroundProblemFixer;
import com.fold1.eulumdat.tools.validator.visitor.ReplaceLampTypeVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExecuteReplacement
extends AbstractEulumdatBackgroundProblemFixer {
    private static final int FIRSTLAMPLINE = 28;
    private static final int LAMPSIZE = 6;
    private final IMarker originalMarker;

    private static int lineToLampIndex(int l) {
        return (l - 28) / 6;
    }

    public ExecuteReplacement(IMarker originalMarker) {
        this.originalMarker = originalMarker;
    }

    @Override
    protected void fixTheProblem(IMarker m, IProgressMonitor monitor) {
        String lamp = m.getAttribute("expected", "");
        IFile f = (IFile)m.getResource();
        ILampVerifier manager = LampManagerPool.getManager((IProject)f.getProject());
        String replacement = manager.correct(lamp);
        int lampindex = ExecuteReplacement.lineToLampIndex(ExecuteReplacement.getLine(m));
        try {
            m.getResource().accept((IResourceVisitor)new ReplaceLampTypeVisitor(replacement, lampindex, monitor));
        }
        catch (CoreException e) {
            EulumdatValidatorLogger.logError("Error in Replacement visitor", e);
        }
    }

    public String getLabel() {
        return "Execute the proposed replacement in the EULUMDAT file";
    }

    @Override
    protected boolean isValidOther(IMarker markerToCheck) {
        if (markerToCheck.equals((Object)this.originalMarker)) {
            return false;
        }
        boolean valid = false;
        try {
            valid = this.originalMarker.getAttribute("message").equals(markerToCheck.getAttribute("message"));
        }
        catch (CoreException e) {
            return false;
        }
        return valid;
    }
}

