/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.data.Eulumdat2;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.fixer.AbstractToolsProblemFixer;
import com.fold1.eulumdat.tools.validator.fixer.AddLampAndEdit;
import com.fold1.eulumdat.tools.validator.fixer.AddLampAsGenericLED;
import com.fold1.eulumdat.tools.validator.fixer.AddLampAsLegal;
import com.fold1.eulumdat.tools.validator.fixer.AddLampAsSkip;
import com.fold1.eulumdat.tools.validator.fixer.AverageNadirValues;
import com.fold1.eulumdat.tools.validator.fixer.AverageZenithValues;
import com.fold1.eulumdat.tools.validator.fixer.ChangeFieldToFileName;
import com.fold1.eulumdat.tools.validator.fixer.ChangeFileNameToField;
import com.fold1.eulumdat.tools.validator.fixer.CreateConverterFix;
import com.fold1.eulumdat.tools.validator.fixer.EditLamp;
import com.fold1.eulumdat.tools.validator.fixer.ExecuteReplacement;
import com.fold1.eulumdat.tools.validator.fixer.FormatEulumdat;
import com.fold1.eulumdat.tools.validator.fixer.OverwriteProductCodeWithPattern;
import com.fold1.eulumdat.tools.validator.fixer.OverwriteProtocolWithPattern;
import com.fold1.eulumdat.tools.validator.fixer.ReplaceDFF;
import com.fold1.eulumdat.tools.validator.fixer.ReplaceDownWardFluxPercent;
import com.fold1.eulumdat.tools.validator.fixer.ReplaceLOR;
import com.fold1.eulumdat.tools.validator.fixer.ReplaceManufacturerName;
import com.fold1.eulumdat.tools.validator.fixer.ReplaceProductCodeWithAlternative;
import com.fold1.eulumdat.tools.validator.fixer.SetSymmetryToRotation;
import com.fold1.eulumdat.tools.validator.fixer.TruncateField;
import com.fold1.eulumdat.tools.validator.visitor.ReplaceProductCodeVisitor;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class EulumdatProblemResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    public static String getCheckerMessage(IMarker marker) {
        return marker.getAttribute("message", "");
    }

    public static String getCheckerName(IMarker marker) {
        return marker.getAttribute("check", "");
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<AbstractToolsProblemFixer> resolutions = new ArrayList<AbstractToolsProblemFixer>();
        String checkerId = EulumdatProblemResolutionGenerator.getCheckerName(marker);
        EulumdatValidatorLogger.logInfo("Resolve problem for " + checkerId + " " + marker.toString());
        if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.FilenameMatchCheck")) {
            resolutions.add(new ChangeFieldToFileName(marker));
            resolutions.add(new ChangeFileNameToField(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.FieldLengthCheck")) {
            resolutions.add(new TruncateField());
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.unknown")) {
            resolutions.add(new AddLampAndEdit(marker));
            resolutions.add(new AddLampAsLegal(marker));
            resolutions.add(new AddLampAsSkip(marker));
            resolutions.add(new AddLampAsGenericLED(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.missing")) {
            resolutions.add(new CreateConverterFix());
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.whitespace")) {
            resolutions.add(new FormatEulumdat());
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.converted")) {
            resolutions.add(new ExecuteReplacement(marker));
            resolutions.add(new EditLamp(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.undefined")) {
            resolutions.add(new EditLamp(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.skipped")) {
            resolutions.add(new EditLamp(marker));
        } else if (checkerId.equals(Eulumdat2.class.getName())) {
            String msg = marker.getAttribute("message", "");
            if (msg != null && msg.startsWith("Symmetry is not ROTATION")) {
                resolutions.add(new SetSymmetryToRotation());
            } else {
                resolutions.add(new FormatEulumdat());
            }
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.lor")) {
            resolutions.add(new ReplaceLOR(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.downflux")) {
            resolutions.add(new ReplaceDownWardFluxPercent(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.values")) {
            resolutions.add(new ReplaceDFF(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.ManufacturerCheck")) {
            resolutions.add(new ReplaceManufacturerName(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.MultipleValuesNadirCheck.nadir")) {
            resolutions.add(new AverageNadirValues(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.MultipleValuesNadirCheck.zenith")) {
            resolutions.add(new AverageZenithValues(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.ProductCodeCheck")) {
            resolutions.add(new ReplaceProductCodeWithAlternative(marker, ReplaceProductCodeVisitor.ReplaceWith.Filename));
            resolutions.add(new ReplaceProductCodeWithAlternative(marker, ReplaceProductCodeVisitor.ReplaceWith.Productname));
            resolutions.add(new OverwriteProductCodeWithPattern(marker));
        } else if (checkerId.equals("com.fold1.eulumdat.tools.validator.checker.ProtocolCheck")) {
            resolutions.add(new OverwriteProtocolWithPattern(marker));
        }
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    public boolean hasResolutions(IMarker marker) {
        String checkerName = EulumdatProblemResolutionGenerator.getCheckerName(marker);
        boolean result = false;
        if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.FilenameMatchCheck")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.FieldLengthCheck")) {
            result = true;
        } else if (checkerName.equals(Eulumdat2.class.getName())) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.converted")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.missing")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.skipped")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.whitespace")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.undefined")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.unknown")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.values")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.downflux")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.lor")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.ManufacturerCheck")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.MultipleValuesNadirCheck.nadir")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.MultipleValuesNadirCheck.zenith")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.ProductCodeCheck")) {
            result = true;
        } else if (checkerName.equals("com.fold1.eulumdat.tools.validator.checker.ProtocolCheck")) {
            result = true;
        }
        return result;
    }
}

