/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatEditor;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.fixer.AbstractEulumdatProblemFixer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;

public class ChangeFileNameToField
extends AbstractEulumdatProblemFixer {
    private IMarker originalMarker;
    private static final String NAME = "com.fold1.eulumdat.tools.validator.checker.FilenameMatchCheck";

    public ChangeFileNameToField() {
    }

    public ChangeFileNameToField(IMarker marker) {
        this.originalMarker = marker;
    }

    public String getLabel() {
        return "Change filename to field value";
    }

    @Override
    protected void fixTheProblem(IMarker marker) {
        IPath path = this.file.getProjectRelativePath().removeLastSegments(1).addTrailingSeparator().append(ChangeFileNameToField.unquote(this.eulumdat.getFileName())).addFileExtension(this.file.getFileExtension());
        String pathname = path.toString();
        EulumdatValidatorLogger.logInfo("New name will be " + pathname);
        ((EulumdatEditor)this.part).doSaveAs();
    }

    @Override
    protected boolean isValidOther(IMarker markerToCheck) {
        assert (this.originalMarker != null);
        if (markerToCheck.equals((Object)this.originalMarker)) {
            return false;
        }
        if (!markerToCheck.getResource().isAccessible()) {
            return false;
        }
        if (!this.isOpenInEditor(markerToCheck.getResource())) {
            return false;
        }
        boolean yes = NAME.equals(ChangeFileNameToField.getCheckerName(markerToCheck));
        return yes;
    }
}

