/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.fixer.AbstractEulumdatBackgroundProblemFixer;
import com.fold1.eulumdat.tools.validator.visitor.ReplaceNadirZenithVisitor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AverageNadirZenithValues
extends AbstractEulumdatBackgroundProblemFixer {
    protected final IMarker originalMarker;

    public AverageNadirZenithValues(IMarker marker) {
        this.originalMarker = marker;
    }

    @Override
    protected void fixTheProblem(IMarker marker, IProgressMonitor monitor) {
        try {
            double average = Double.parseDouble(marker.getAttribute("expected", "ATTRIBUTE NOT FOUND_ATTR"));
            int index = Integer.parseInt(marker.getAttribute("index", "ATTRIBUTE NOT FOUND_ATTR"));
            int gamma = Integer.parseInt(marker.getAttribute("gamma", "ATTRIBUTE NOT FOUND_ATTR"));
            marker.getResource().accept((IResourceVisitor)new ReplaceNadirZenithVisitor(average, index, gamma, monitor));
        }
        catch (NumberFormatException | CoreException e) {
            EulumdatValidatorLogger.logError(e);
        }
    }

    public abstract String getLabel();

    @Override
    public boolean isValidOther(IMarker markerToCheck) {
        if (markerToCheck.equals((Object)this.originalMarker)) {
            return false;
        }
        if (!this.fullVersion && !markerToCheck.getResource().equals((Object)this.originalMarker.getResource())) {
            return false;
        }
        if (!markerToCheck.getResource().isAccessible()) {
            return false;
        }
        return this.nameCheck(markerToCheck);
    }

    public abstract boolean nameCheck(IMarker var1);
}

