/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.eulumdat.tools.editors.converter.ConverterEditor;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import com.fold1.eulumdat.tools.validator.fixer.AbstractConversionProblemFixer;
import org.eclipse.core.resources.IMarker;

public class AddLampAsLegal
extends AbstractConversionProblemFixer {
    private IMarker originalMarker;

    private AddLampAsLegal() {
    }

    public AddLampAsLegal(IMarker marker) {
        this.originalMarker = marker;
    }

    @Override
    protected void fixTheProblem(IMarker marker) {
        String lamp = marker.getAttribute("expected", "");
        String replacement = this.manager.correct(lamp);
        this.processLamp(lamp, replacement);
    }

    public String getDescription() {
        return this.getLabel();
    }

    public String getLabel() {
        return "Add all unknown lamps in selected files as a legal lightsource to 'converter.lamps'";
    }

    @Override
    protected boolean isValidOther(IMarker markerToCheck) {
        return RegistrationController.isValidFullLicense((boolean)false) && !markerToCheck.equals((Object)this.originalMarker) && markerToCheck.getAttribute("check", "").equals("com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.unknown");
    }

    protected void processLamp(String from, String to) {
        if (!from.equals("") && this.conversionEditor instanceof ConverterEditor) {
            ((ConverterEditor)this.conversionEditor).appendConversion(from, from);
        }
    }
}

