/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.data.Eulumdat2;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class AbstractToolsProblemFixer
extends WorkbenchMarkerResolution
implements IMarkerResolution2 {
    public static final String DEFAULT_VALUE = "ATTRIBUTE NOT FOUND_ATTR";
    protected Eulumdat2 eulumdat;
    protected IFile file;
    protected int line;
    protected IWorkbenchPage page;

    protected static String doubleQuote(String s) {
        return "\"" + AbstractToolsProblemFixer.unquote(s) + "\"";
    }

    public static String getCheckerMessage(IMarker marker) {
        return marker.getAttribute("message", "");
    }

    public static String getCheckerName(IMarker marker) {
        return marker.getAttribute("check", "");
    }

    protected static int getLine(IMarker marker) {
        return marker.getAttribute("lineNumber", 0);
    }

    protected static boolean isQuoted(String s) {
        return s.startsWith("\"") && s.endsWith("\"");
    }

    protected static String properName(IFile file) {
        return file.getName().substring(0, file.getName().indexOf(46));
    }

    protected static String singleQuote(String s) {
        return "'" + AbstractToolsProblemFixer.unquote(s) + "'";
    }

    protected static String truncate(String s, int maxlen) {
        if (s.length() > maxlen) {
            return s.substring(0, maxlen);
        }
        return s;
    }

    protected static String unquote(String s) {
        if (AbstractToolsProblemFixer.isQuoted(s)) {
            return s.substring(1, s.length() - 1).trim();
        }
        if (s.startsWith("\"")) {
            return s.substring(1, s.length()).trim();
        }
        return s.trim();
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> others = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (this.isValidOther(marker)) {
                others.add(marker);
            }
            if (others.size() == 5 && !RegistrationController.isValidFullLicense((boolean)true)) break;
            ++n2;
        }
        return others.toArray(new IMarker[0]);
    }

    protected boolean isOpenInEditor(IResource resource) {
        if (!(resource instanceof IFile)) {
            return false;
        }
        this.file = (IFile)resource;
        FileEditorInput other = new FileEditorInput(this.file);
        this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return this.page.findEditor((IEditorInput)other) == null;
    }

    protected boolean isValidOther(IMarker markerToCheck) {
        return false;
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        monitor.beginTask("Fixing ", markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            monitor.subTask(AbstractToolsProblemFixer.getCheckerMessage(marker));
            this.run(marker);
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
    }
}

