/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatEditor;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.SWTResourceManager;
import com.fold1.eulumdat.tools.validator.fixer.AbstractToolsProblemFixer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractEulumdatProblemFixer
extends AbstractToolsProblemFixer {
    private static final String EULUMDATICONFILE = "icons/eulumdat.png";
    protected static final String START_OF_VALUE = ":";
    protected IEditorPart part;

    protected abstract void fixTheProblem(IMarker var1);

    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        return SWTResourceManager.getBundleImage(Platform.getBundle((String)"com.fold1.eulumdat.tools"), EULUMDATICONFILE);
    }

    public void run(IMarker marker) {
        Display display = Display.getCurrent();
        IResource resource = marker.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        this.file = (IFile)resource;
        this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            this.part = IDE.openEditor((IWorkbenchPage)this.page, (IFile)this.file, (boolean)true);
        }
        catch (PartInitException e) {
            EulumdatValidatorLogger.logError(e);
            return;
        }
        if (this.part instanceof EulumdatEditor) {
            this.eulumdat = ((EulumdatEditor)this.part).getEulumdat();
            this.line = AbstractEulumdatProblemFixer.getLine(marker);
            this.fixTheProblem(marker);
            ((EulumdatEditor)this.part).eulumdatChanged(AbstractEulumdatProblemFixer.getLine(marker));
            ((EulumdatEditor)this.part).gotoMarker(marker);
        }
        if (display != null && display.readAndDispatch()) {
            display.update();
        }
    }
}

