/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.fixer;

import com.fold1.eulumdat.tools.preferences.RegistrationController;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.SWTResourceManager;
import com.fold1.eulumdat.tools.validator.fixer.AbstractToolsProblemFixer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractEulumdatBackgroundProblemFixer
extends AbstractToolsProblemFixer {
    private static final String EULUMDATICONFILE = "icons/eulumdat.png";
    protected static final String START_OF_VALUE = ":";
    protected final boolean fullVersion = RegistrationController.isValidFullLicense((boolean)false);

    protected abstract void fixTheProblem(IMarker var1, IProgressMonitor var2);

    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        return SWTResourceManager.getBundleImage(Platform.getBundle((String)"com.fold1.eulumdat.tools"), EULUMDATICONFILE);
    }

    public void run(IMarker m) {
        this.fixTheProblem(m, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void run(IMarker[] markers, IProgressMonitor monitor) {
        try {
            ResourcesPlugin.getWorkspace().run(monitor1 -> {
                monitor1.beginTask("Fixing", markers.length);
                IMarker[] iMarkerArray2 = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = iMarkerArray2[n2];
                    this.fixTheProblem(m, monitor1);
                    Display display = Display.getCurrent();
                    if (display != null && display.readAndDispatch()) {
                        display.update();
                    }
                    monitor1.worked(1);
                    ++n2;
                }
                monitor1.done();
            }, monitor);
        }
        catch (CoreException e) {
            EulumdatValidatorLogger.logError("Problem applying Quick Fixes", e);
        }
    }
}

