/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.checker;

import com.fold1.data.IEulumdatRO;
import com.fold1.eulumdat.tools.validator.checker.AbstractRuleChecker;
import com.fold1.eulumdat.tools.validator.checker.ProblemReporter;
import net.jcip.annotations.Immutable;

@Immutable
public final class PowerNotZero
extends AbstractRuleChecker {
    public static final String ID = "com.fold1.eulumdat.tools.validator.checker.PowerNotZero";
    private static final PowerNotZero instance = new PowerNotZero();

    public static PowerNotZero getInstance() {
        return instance;
    }

    private static int getLine(int i) {
        return 32 + 6 * i;
    }

    private PowerNotZero() {
    }

    @Override
    public boolean check(String file, IEulumdatRO eu, ProblemReporter pr) {
        int errors = 0;
        int i = 0;
        while (i < eu.getNumberOfLampSets()) {
            double power = eu.getLampSetRO(i).getPowerUsed();
            if (power <= 0.0) {
                ++errors;
                pr.report("Lamp power should be greater than zero", PowerNotZero.getLine(i), 1, ID);
            }
            ++i;
        }
        return errors == 0;
    }
}

