/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.checker;

import com.fold1.data.IEulumdatRO;
import com.fold1.eulumdat.tools.validator.checker.AbstractRuleChecker;
import com.fold1.eulumdat.tools.validator.checker.ProblemReporter;
import com.fold1.util.NumberOutput;
import java.util.HashMap;
import net.jcip.annotations.Immutable;

@Immutable
public final class MultipleValuesNadirCheck
extends AbstractRuleChecker {
    private static final int PRECISION = 3;
    public static final String ID = "com.fold1.eulumdat.tools.validator.checker.MultipleValuesNadirCheck";
    public static final String ID_NADIR = "com.fold1.eulumdat.tools.validator.checker.MultipleValuesNadirCheck.nadir";
    public static final String ID_ZENITH = "com.fold1.eulumdat.tools.validator.checker.MultipleValuesNadirCheck.zenith";
    private static final int NADIR = 0;
    private static final int ZENITH = 180;
    private static final MultipleValuesNadirCheck instance = new MultipleValuesNadirCheck();

    public static MultipleValuesNadirCheck getInstance() {
        return instance;
    }

    private static int getLine(IEulumdatRO eu, int c, int gamma) {
        return 37 + 6 * eu.getNumberOfLampSets() + eu.getNg() + eu.getNoCPlanes() + c * eu.getNg() + gamma;
    }

    private MultipleValuesNadirCheck() {
    }

    @Override
    public boolean check(String fname, IEulumdatRO eu, ProblemReporter pr) {
        int errors = 0;
        errors += this.checkNadir(eu, pr);
        return (errors += this.checkZenith(eu, pr)) == 0;
    }

    private int checkNadir(IEulumdatRO eu, ProblemReporter pr) {
        double intensity = eu.getAverageValueForGamma(0);
        String digits = NumberOutput.digits((double)intensity, (int)3);
        int errors = 0;
        int c = 0;
        while (c < eu.getNoCPlaneValues()) {
            double intensity2 = eu.getValue(c, 0);
            if (!digits.equals(NumberOutput.digits((double)intensity2, (int)3))) {
                ++errors;
                HashMap<String, String> expected = new HashMap<String, String>();
                expected.put("expected", digits);
                expected.put("gamma", Integer.toString(0));
                expected.put("index", Integer.toString(c));
                pr.report("Intensity at gamma 0 in C-plane " + this.leadingSpaces(c) + c + " (" + NumberOutput.digits((double)intensity2, (int)3) + ") is different from average (" + NumberOutput.digits((double)intensity, (int)3) + ")", MultipleValuesNadirCheck.getLine(eu, c, 0), 2, ID_NADIR, expected);
            }
            ++c;
        }
        return errors;
    }

    private int checkZenith(IEulumdatRO eu, ProblemReporter pr) {
        int lastGammaIndex = eu.getAnglesGammaNumber() - 1;
        double lastGamma = eu.getAngleGamma(lastGammaIndex);
        if (lastGamma < 180.0) {
            return 0;
        }
        double intensity = eu.getAverageValueForGamma(lastGammaIndex);
        String digits = NumberOutput.digits((double)intensity, (int)3);
        int errors = 0;
        int c = 0;
        while (c < eu.getNoCPlaneValues()) {
            double intensity2 = eu.getValue(c, lastGammaIndex);
            if (!digits.equals(NumberOutput.digits((double)intensity2, (int)3))) {
                ++errors;
                HashMap<String, String> expected = new HashMap<String, String>();
                expected.put("expected", digits);
                expected.put("gamma", Integer.toString(lastGammaIndex));
                expected.put("index", Integer.toString(c));
                pr.report("Intensity at gamma 180 in C-plane " + this.leadingSpaces(c) + c + " (" + NumberOutput.digits((double)intensity2, (int)3) + ") is different from average (" + NumberOutput.digits((double)intensity, (int)3) + ")", MultipleValuesNadirCheck.getLine(eu, c, lastGammaIndex), 2, ID_ZENITH, expected);
            }
            ++c;
        }
        return errors;
    }

    public String leadingSpaces(int c) {
        if (c < 10) {
            return "  ";
        }
        if (c < 100) {
            return " ";
        }
        return "";
    }
}

