/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.checker;

import com.fold1.data.IEulumdatRO;
import com.fold1.eulumdat.tools.validator.checker.AbstractREMatchChecker;
import com.fold1.eulumdat.tools.validator.checker.ProblemReporter;
import net.jcip.annotations.Immutable;

@Immutable
public final class ManufacturerCheck
extends AbstractREMatchChecker {
    public static final String ID = "com.fold1.eulumdat.tools.validator.checker.ManufacturerCheck";
    private static final String MANUFACTURER_DOES_NOT_MATCH1 = "Manufacturer \"";
    private static final String MANUFACTURER_DOES_NOT_MATCH2 = "\" does not match pattern : ";

    public static ManufacturerCheck getInstance(String pattern) {
        ManufacturerCheck temp = new ManufacturerCheck();
        temp.setPattern(pattern);
        return temp;
    }

    private ManufacturerCheck() {
    }

    @Override
    public boolean check(String file, IEulumdatRO eu, ProblemReporter pr) {
        if (this.matches(eu.getProductBrand())) {
            return true;
        }
        pr.report(MANUFACTURER_DOES_NOT_MATCH1 + eu.getProductBrand() + MANUFACTURER_DOES_NOT_MATCH2 + this.getPattern(), 1, 1, ID, this.getPattern());
        return false;
    }
}

