/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.checker;

import com.fold1.data.AlgorithmLiTG;
import com.fold1.data.AlgorithmLiTG35;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.RoomIndex;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.checker.AbstractRuleChecker;
import com.fold1.eulumdat.tools.validator.checker.ProblemReporter;
import com.fold1.eulumdat.tools.validator.util.ValidatorSafeRunnable;
import com.fold1.util.NumberOutput;
import java.util.HashMap;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

@ThreadSafe
public final class LightOutputRatioChecker
extends AbstractRuleChecker {
    private static final String A_PROCESSING_ERROR_OCCURRED = "A processing error occurred";
    private static final String CANNOT_CHECK = "Cannot check : ";
    private static final double DFFDELTA = 0.05;
    public static final String DIRECT_FLUX_FACTORS_NOT_SPECIFIED = "Downward Flux > 0.0 but Direct Ratio's (DFF) not specified";
    public static final String DIRECT_RATIO_1 = "Direct Ratio[";
    private static final String DIRECT_RATIO_2 = "] different from calculated, expected : ";
    private static final double DOWNFLUXDELTA = 0.5;
    public static final String DOWNWARD_FLUX_PERCENTAGE_DIFFERENT_FROM_CALCULATED_EXPECTED = "Downward Flux Percentage different from calculated, expected : ";
    public static final String ID = "com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker";
    public static final String ID_DFF_PRESENT = "com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.present";
    public static final String ID_DFF_VALUES = "com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.values";
    public static final String ID_DOWNFLUX = "com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.downflux";
    public static final String ID_LOR = "com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker.lor";
    public static final String LIGHT_OUTPUT_RATIO_DIFFERENT_FROM_CALCULATED_EXPECTED = "Light Output Ratio different from calculated, expected : ";
    private static final double LORDELTA = 0.5;
    private static final double MINDFF = 1.0E-4;
    private static final double MINPERCENT = 0.3;
    private boolean checkDFF;
    private boolean checkDFFpresent;
    private boolean checkDownFlux;
    private boolean checkLOR;

    private static int checkDirectRatios(final AlgorithmLiTG calculator, final IEulumdatRO eu, final String file, final ProblemReporter pr) {
        ValidatorSafeRunnable code = new ValidatorSafeRunnable(){
            int k = 0;

            @Override
            public void handleException(Throwable exception) {
                ++this.localerrors;
                EulumdatValidatorLogger.logError(LightOutputRatioChecker.CANNOT_CHECK + file, exception);
                pr.report(LightOutputRatioChecker.A_PROCESSING_ERROR_OCCURRED, LightOutputRatioChecker.getLineNo(this.k, eu), 2, LightOutputRatioChecker.ID, exception);
            }

            @Override
            public void run() throws Exception {
                double[] dff = calculator.calculateDFF(eu);
                this.k = 0;
                while (this.k < RoomIndex.NUMBER_OF) {
                    if (LightOutputRatioChecker.outOfRange(dff[this.k], eu.getDirectFluxFactor(this.k), 0.05)) {
                        ++this.localerrors;
                        String digits = NumberOutput.digits((double)dff[this.k], (int)6);
                        HashMap<String, String> expected = new HashMap<String, String>();
                        expected.put("expected", digits);
                        expected.put("index", Integer.toString(this.k));
                        pr.report(LightOutputRatioChecker.DIRECT_RATIO_1 + this.k + LightOutputRatioChecker.DIRECT_RATIO_2 + digits, LightOutputRatioChecker.getLineNo(this.k, eu), 1, LightOutputRatioChecker.ID_DFF_VALUES, expected);
                    }
                    ++this.k;
                }
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        return code.getLocalerrors();
    }

    private static int checkDirectRatiosPresent(AlgorithmLiTG calculator, IEulumdatRO eu, String file, ProblemReporter pr) {
        int errors;
        block4: {
            errors = 0;
            try {
                double downwardFluxPerc = calculator.calculateDownwardFluxPerc(eu);
                if (0.3 > downwardFluxPerc) break block4;
                int k = 0;
                while (k < RoomIndex.NUMBER_OF) {
                    if (eu.getDirectFluxFactor(k) < 1.0E-4) {
                        ++errors;
                        pr.report(DIRECT_FLUX_FACTORS_NOT_SPECIFIED, LightOutputRatioChecker.getLineNo(k, eu), 2, ID_DFF_PRESENT);
                        break;
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                EulumdatValidatorLogger.logError(CANNOT_CHECK + file, e);
            }
        }
        return errors;
    }

    private static int checkDownFlux(final AlgorithmLiTG calculator, final IEulumdatRO eu, final String file, final ProblemReporter pr) {
        ValidatorSafeRunnable code = new ValidatorSafeRunnable(){

            @Override
            public void handleException(Throwable exception) {
                ++this.localerrors;
                EulumdatValidatorLogger.logError(LightOutputRatioChecker.CANNOT_CHECK + file, exception);
                pr.report(LightOutputRatioChecker.A_PROCESSING_ERROR_OCCURRED, 22, 2, LightOutputRatioChecker.ID, exception);
            }

            @Override
            public void run() throws Exception {
                double downwardFluxPerc = calculator.calculateDownwardFluxPerc(eu);
                if (!(0.3 > downwardFluxPerc) && LightOutputRatioChecker.outOfRange(downwardFluxPerc, eu.getDownwardFluxPercentage(), 0.5)) {
                    ++this.localerrors;
                    String digits = NumberOutput.digits((double)downwardFluxPerc, (int)1);
                    pr.report(LightOutputRatioChecker.DOWNWARD_FLUX_PERCENTAGE_DIFFERENT_FROM_CALCULATED_EXPECTED + digits, 22, 1, LightOutputRatioChecker.ID_DOWNFLUX, digits);
                }
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        return code.getLocalerrors();
    }

    private static int checkLOR(final AlgorithmLiTG calculator, final IEulumdatRO eu, final String file, final ProblemReporter pr) {
        ValidatorSafeRunnable code = new ValidatorSafeRunnable(){

            @Override
            public void handleException(Throwable exception) {
                ++this.localerrors;
                EulumdatValidatorLogger.logError(LightOutputRatioChecker.CANNOT_CHECK + file, exception);
                pr.report(LightOutputRatioChecker.A_PROCESSING_ERROR_OCCURRED, 23, 2, LightOutputRatioChecker.ID, exception);
            }

            @Override
            public void run() throws Exception {
                double lor = calculator.calculateLORL(eu);
                if (LightOutputRatioChecker.outOfRange(lor, eu.getEfficacy(), 0.5)) {
                    String digits = NumberOutput.digits((double)lor, (int)1);
                    pr.report(LightOutputRatioChecker.LIGHT_OUTPUT_RATIO_DIFFERENT_FROM_CALCULATED_EXPECTED + digits, 23, 1, LightOutputRatioChecker.ID_LOR, lor);
                    ++this.localerrors;
                }
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        return code.getLocalerrors();
    }

    public static LightOutputRatioChecker getInstance() {
        return new LightOutputRatioChecker();
    }

    private static int getLineNo(int k, IEulumdatRO eu) {
        return 27 + 6 * eu.getNumberOfLampSets() + k;
    }

    private static boolean outOfRange(double t, double b, double accuray) {
        if (t == 0.0 && b == 0.0) {
            return false;
        }
        return Math.abs(t - b) > accuray;
    }

    private LightOutputRatioChecker() {
    }

    @Override
    public boolean check(String fname, IEulumdatRO eu, ProblemReporter pr) {
        int errors = 0;
        AlgorithmLiTG35 calculator = new AlgorithmLiTG35();
        if (this.checkLOR) {
            errors += LightOutputRatioChecker.checkLOR((AlgorithmLiTG)calculator, eu, fname, pr);
        }
        if (this.checkDownFlux) {
            errors += LightOutputRatioChecker.checkDownFlux((AlgorithmLiTG)calculator, eu, fname, pr);
        }
        if (this.checkDFFpresent) {
            errors += LightOutputRatioChecker.checkDirectRatiosPresent((AlgorithmLiTG)calculator, eu, fname, pr);
        }
        if (this.checkDFF) {
            errors += LightOutputRatioChecker.checkDirectRatios((AlgorithmLiTG)calculator, eu, fname, pr);
        }
        return errors == 0;
    }

    public LightOutputRatioChecker setCheckDFF(boolean checkDFF) {
        this.checkDFF = checkDFF;
        return this;
    }

    public LightOutputRatioChecker setCheckDFFpresent(boolean checkDFFpresent) {
        this.checkDFFpresent = checkDFFpresent;
        return this;
    }

    public LightOutputRatioChecker setCheckDownFlux(boolean checkDownFlux) {
        this.checkDownFlux = checkDownFlux;
        return this;
    }

    public LightOutputRatioChecker setCheckLOR(boolean checkLOR) {
        this.checkLOR = checkLOR;
        return this;
    }
}

