/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.checker;

import com.fold1.data.IEulumdatRO;
import com.fold1.eulumdat.tools.lamps.ILampVerifier;
import com.fold1.eulumdat.tools.validator.checker.AbstractRuleChecker;
import com.fold1.eulumdat.tools.validator.checker.ProblemReporter;
import net.jcip.annotations.Immutable;

@Immutable
public final class LampTypeKnown
extends AbstractRuleChecker {
    public static final String ID = "com.fold1.eulumdat.tools.validator.checker.LampTypeKnown";
    public static final String ID_CONVERTED = "com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.converted";
    public static final String ID_MISSING_CONVERTER = "com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.missing";
    public static final String ID_SKIPPED = "com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.skipped";
    public static final String ID_TRAILING_WHITESPACE = "com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.whitespace";
    public static final String ID_UNDEFINED = "com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.undefined";
    public static final String ID_UNKNOWN = "com.fold1.eulumdat.tools.validator.checker.LampTypeKnown.unknown";
    public static final String LAMP_CONVERTED = "Lamp designation '";
    public static final String LAMP_CONVERTED2 = "' will be converted to : '";
    public static final String LAMP_CONVERTER_NOT_FOUND = "Manager cannot find 'converter.lamps', file not checked";
    public static final String LAMP_EOM = "'";
    public static final String LAMP_REPLACEMENT_UNDEFINED = "Lamp designation has no replacement defined : '";
    public static final String LAMP_SKIPPED = "Lamp designation will be skipped : '";
    public static final String LAMP_TRAILINGWHITESPACE = "Lamp designation has trailing white space : '";
    public static final String LAMP_UNKNOWN = "Lamp designation unknown in 'converter.lamps' : '";
    private final ILampVerifier manager;

    public static LampTypeKnown getInstance(ILampVerifier manager) {
        return new LampTypeKnown(manager);
    }

    private static int lampIndexToLine(int i) {
        return 28 + 6 * i;
    }

    private static boolean trailingWhitespace(String type) {
        return type.endsWith("\t") || type.endsWith(" ");
    }

    private static String unquote(String s) {
        if (s.startsWith(LAMP_EOM) && s.endsWith(LAMP_EOM)) {
            return s.substring(1, s.length() - 1).trim();
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1).trim();
        }
        if (s.startsWith("\"")) {
            return s.substring(1, s.length()).trim();
        }
        return s.trim();
    }

    private LampTypeKnown() {
        this(null);
    }

    public LampTypeKnown(ILampVerifier manager) {
        this.manager = manager;
    }

    @Override
    public boolean check(String file, IEulumdatRO eu, ProblemReporter pr) {
        int errors = 0;
        if (this.manager == null || !this.manager.isInited()) {
            pr.report(LAMP_CONVERTER_NOT_FOUND, LampTypeKnown.lampIndexToLine(0), 2, ID_MISSING_CONVERTER);
            return false;
        }
        int i = 0;
        while (i < eu.getNumberOfLampSets()) {
            String type = LampTypeKnown.unquote(eu.getLampSetRO(i).getType());
            if (LampTypeKnown.trailingWhitespace(eu.getLampSetRO(i).getType())) {
                ++errors;
                pr.report(LAMP_TRAILINGWHITESPACE + eu.getLampSetRO(i).getType() + LAMP_EOM, LampTypeKnown.lampIndexToLine(i), 1, ID_TRAILING_WHITESPACE);
            }
            if (!this.manager.known(type)) {
                ++errors;
                pr.report(LAMP_UNKNOWN + type + LAMP_EOM, LampTypeKnown.lampIndexToLine(i), 2, ID_UNKNOWN, type);
            } else if (!this.manager.replaceable(type)) {
                ++errors;
                pr.report(LAMP_REPLACEMENT_UNDEFINED + type + LAMP_EOM, LampTypeKnown.lampIndexToLine(i), 2, ID_UNDEFINED, type);
            } else if (this.manager.skip(type)) {
                ++errors;
                pr.report(LAMP_SKIPPED + type + LAMP_EOM, LampTypeKnown.lampIndexToLine(i), 0, ID_SKIPPED, type);
            } else if (!this.manager.legal(type)) {
                ++errors;
                pr.report(LAMP_CONVERTED + type + LAMP_CONVERTED2 + this.manager.correct(type) + LAMP_EOM, LampTypeKnown.lampIndexToLine(i), 0, ID_CONVERTED, type);
            }
            ++i;
        }
        return errors == 0;
    }
}

