/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.checker;

import com.fold1.data.IEulumdatRO;
import com.fold1.eulumdat.tools.validator.checker.AbstractRuleChecker;
import com.fold1.eulumdat.tools.validator.checker.EulumdatChecker;
import com.fold1.eulumdat.tools.validator.checker.ProblemReporter;
import net.jcip.annotations.Immutable;

@Immutable
public final class FilenameMatchCheck
extends AbstractRuleChecker {
    public static final String ID = "com.fold1.eulumdat.tools.validator.checker.FilenameMatchCheck";
    private static final FilenameMatchCheck instance = new FilenameMatchCheck();

    public static EulumdatChecker getInstance() {
        return instance;
    }

    private FilenameMatchCheck() {
    }

    @Override
    public boolean check(String fname, IEulumdatRO eu, ProblemReporter pr) {
        String token = eu.getFileName().replaceAll("\"", "");
        String name = fname;
        if (-1 != name.indexOf(46)) {
            name = name.substring(0, name.indexOf(46));
        }
        if (!token.equalsIgnoreCase(name)) {
            pr.report("Filename '" + token + "' doesn't match '" + name + "'", 11, 1, ID);
        }
        return true;
    }
}

