/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.checker;

import com.fold1.data.IEulumdatRO;
import com.fold1.eulumdat.tools.validator.checker.AbstractRuleChecker;
import com.fold1.eulumdat.tools.validator.checker.ProblemReporter;
import net.jcip.annotations.Immutable;

@Immutable
public final class FilenameLenCheck
extends AbstractRuleChecker {
    private static final int FILENAME_MAXLEN = 8;
    public static final String ID = "com.fold1.eulumdat.tools.validator.checker.FilenameLenCheck";
    private static FilenameLenCheck instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilenameLenCheck getInstance() {
        FilenameLenCheck r = instance;
        if (r != null) return instance;
        Class<FilenameLenCheck> clazz = FilenameLenCheck.class;
        synchronized (FilenameLenCheck.class) {
            r = instance;
            if (r != null) return instance;
            instance = r = new FilenameLenCheck();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private FilenameLenCheck() {
    }

    @Override
    public boolean check(String file, IEulumdatRO eu, ProblemReporter pr) {
        String token = eu.getFileName().replaceAll("\"", "");
        if (token.length() > 8) {
            pr.report("Filename '" + token + "' exceeds max length of 8 chars", 11, 1, ID);
        }
        return true;
    }
}

