/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.checker;

import com.fold1.data.IEulumdatRO;
import com.fold1.eulumdat.tools.validator.checker.AbstractRuleChecker;
import com.fold1.eulumdat.tools.validator.checker.ProblemReporter;
import net.jcip.annotations.Immutable;

@Immutable
public final class FieldLengthCheck
extends AbstractRuleChecker {
    private static final String CHARACTERS = " characters";
    public static final int EULUMDAT_DEFAULT_MAXLEN = 255;
    public static final int EULUMDAT_V1_MAXLEN = 24;
    public static final int EULUMDAT_V2_MAXLEN = 78;
    public static final String ID = "com.fold1.eulumdat.tools.validator.checker.FieldLengthCheck";
    private final int maxfirmlen;
    private final int maxlen;

    public static FieldLengthCheck getInstance(EulumdatVersion version) {
        return version.getCheck();
    }

    private FieldLengthCheck() {
        this(255, 255);
    }

    private FieldLengthCheck(int maxfirmlen, int maxlen) {
        this.maxfirmlen = maxfirmlen;
        this.maxlen = maxlen;
    }

    @Override
    public boolean check(String file, IEulumdatRO eu, ProblemReporter pr) {
        int errors = 0;
        if (eu.getProductBrand().length() > this.maxfirmlen) {
            pr.report("Manufacturer exceeds length of " + this.maxfirmlen + CHARACTERS, 1, 1, ID, this.maxfirmlen);
            ++errors;
        }
        if (eu.getProtocol().length() > this.maxlen) {
            pr.report("Test Report No exceeds length of " + this.maxlen + CHARACTERS, 8, 1, ID, this.maxlen);
            ++errors;
        }
        if (eu.getProductName().length() > this.maxlen) {
            pr.report("Luminaire Name exceeds length of " + this.maxlen + CHARACTERS, 9, 1, ID, this.maxlen);
            ++errors;
        }
        if (eu.getProductCode().length() > this.maxlen) {
            pr.report("Luminaire Number exceeds length of " + this.maxlen + CHARACTERS, 10, 1, ID, this.maxlen);
            ++errors;
        }
        if (eu.getDateUser().length() > this.maxlen) {
            pr.report("Date/name exceeds length of " + this.maxlen + CHARACTERS, 12, 1, ID, this.maxlen);
            ++errors;
        }
        return errors == 0;
    }

    static enum EulumdatVersion {
        DEFAULT(255, 255),
        EULUMDAT1(255, 24),
        EULUMDAT2(78, 78);

        private FieldLengthCheck check;

        private EulumdatVersion(int maxfirmlen, int maxlen) {
            this.check = new FieldLengthCheck(maxfirmlen, maxlen);
        }

        public FieldLengthCheck getCheck() {
            return this.check;
        }
    }
}

