/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.checker;

import com.bdaum.overlaypages.OverlayUtils;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.parser.ParserFactory;
import com.fold1.eulumdat.tools.lamps.ILampVerifier;
import com.fold1.eulumdat.tools.lamps.LampManagerPool;
import com.fold1.eulumdat.tools.preferences.RegistrationController;
import com.fold1.eulumdat.tools.validator.checker.DateCheck;
import com.fold1.eulumdat.tools.validator.checker.EulumdatChecker;
import com.fold1.eulumdat.tools.validator.checker.FieldLengthCheck;
import com.fold1.eulumdat.tools.validator.checker.FilenameLenCheck;
import com.fold1.eulumdat.tools.validator.checker.FilenameMatchCheck;
import com.fold1.eulumdat.tools.validator.checker.LampTypeKnown;
import com.fold1.eulumdat.tools.validator.checker.LightOutputRatioChecker;
import com.fold1.eulumdat.tools.validator.checker.ManufacturerCheck;
import com.fold1.eulumdat.tools.validator.checker.MultipleValuesNadirCheck;
import com.fold1.eulumdat.tools.validator.checker.PowerNotZero;
import com.fold1.eulumdat.tools.validator.checker.ProblemReporter;
import com.fold1.eulumdat.tools.validator.checker.ProductCodeCheck;
import com.fold1.eulumdat.tools.validator.checker.ProductCodeNotEmpty;
import com.fold1.eulumdat.tools.validator.checker.ProtocolCheck;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;

public class CheckerList {
    private boolean checkCalcValuesDFF;
    private boolean checkCalcValuesDownFlux;
    private boolean checkCalcValuesLOR;
    private boolean checkDate;
    private boolean checkDFFpresent;
    private boolean checkFieldLength;
    private boolean checkFilenameLen;
    private boolean checkFilenameMatch;
    private boolean checkLampTypeKnown;
    private ArrayList<EulumdatChecker> checklist;
    private boolean checkManufacturer;
    private boolean checkNadir;
    private boolean checkPowerNotZero;
    private boolean checkProductCode;
    private boolean checkProductCodeNotEmpty;
    private boolean checkProtocol;
    private IPreferenceStore store;
    private boolean useStrictParser;

    public CheckerList(IProject p) {
        this.store = OverlayUtils.getStoreToUse((IResource)p, (String)"com.fold1.eulumdat.tools.preferences.ValidatorPreferencePage");
        this.getPrefs();
        this.checklist = new ArrayList();
        if (this.checklist != null) {
            String pattern;
            if (this.checkLampTypeKnown) {
                ILampVerifier manager = LampManagerPool.getManager((IProject)p);
                this.checklist.add(LampTypeKnown.getInstance(manager));
            }
            if (!RegistrationController.isOKToUse((boolean)false)) {
                return;
            }
            if (this.checkNadir) {
                this.checklist.add(MultipleValuesNadirCheck.getInstance());
            }
            if (this.checkProductCodeNotEmpty) {
                this.checklist.add(ProductCodeNotEmpty.getInstance());
            }
            if (this.checkProductCode) {
                pattern = this.store.getString("MatchProductCodeRE");
                this.checklist.add(ProductCodeCheck.getInstance(pattern));
            }
            if (this.checkPowerNotZero) {
                this.checklist.add(PowerNotZero.getInstance());
            }
            if (this.checkManufacturer) {
                pattern = this.store.getString("MatchManufacturerRE");
                this.checklist.add(ManufacturerCheck.getInstance(pattern));
            }
            if (this.checkDate) {
                pattern = this.store.getString("MatchDateRE");
                this.checklist.add(DateCheck.getInstance(pattern));
            }
            if (this.checkFilenameMatch) {
                this.checklist.add(FilenameMatchCheck.getInstance());
            }
            if (this.checkFilenameLen) {
                this.checklist.add(FilenameLenCheck.getInstance());
            }
            if (this.checkCalcValuesLOR || this.checkCalcValuesDFF || this.checkDFFpresent || this.checkCalcValuesDownFlux) {
                LightOutputRatioChecker checker = LightOutputRatioChecker.getInstance().setCheckDFF(this.checkCalcValuesDFF).setCheckLOR(this.checkCalcValuesLOR).setCheckDownFlux(this.checkCalcValuesDownFlux).setCheckDFFpresent(this.checkDFFpresent);
                this.checklist.add(checker);
            }
            if (this.checkProtocol) {
                pattern = this.store.getString("MatchProtocolRE");
                this.checklist.add(ProtocolCheck.getInstance(pattern));
            }
            if (this.checkFieldLength || this.useStrictParser) {
                String pref = this.store.getString("EulumdatVersion");
                FieldLengthCheck.EulumdatVersion v = FieldLengthCheck.EulumdatVersion.DEFAULT;
                if (pref.equals("eulumdat1")) {
                    v = FieldLengthCheck.EulumdatVersion.EULUMDAT1;
                } else if (pref.equals("eulumdat2")) {
                    v = FieldLengthCheck.EulumdatVersion.EULUMDAT2;
                } else if (pref.equals("none")) {
                    v = FieldLengthCheck.EulumdatVersion.DEFAULT;
                }
                this.checklist.add(FieldLengthCheck.getInstance(v));
            }
        }
    }

    public void clear() {
        this.checklist.clear();
    }

    private void getPrefs() {
        this.useStrictParser = this.store.getBoolean("StrictEulumdatParser");
        ParserFactory.setStrict((boolean)this.useStrictParser);
        this.checkFieldLength = !this.store.getString("EulumdatVersion").equals("none");
        this.checkLampTypeKnown = this.store.getBoolean("LampTypeKnown");
        this.checkProductCodeNotEmpty = this.store.getBoolean("ProductCodeNotEmpty");
        this.checkProductCode = this.store.getBoolean("MatchProductCode");
        this.checkPowerNotZero = this.store.getBoolean("PowerNotZero");
        this.checkManufacturer = this.store.getBoolean("MatchManufacturer");
        this.checkNadir = this.store.getBoolean("CheckNadir");
        this.checkProtocol = this.store.getBoolean("MatchProtocol");
        this.checkFilenameMatch = this.store.getBoolean("FilenameMatch");
        this.checkFilenameLen = this.store.getBoolean("FilenameLength");
        this.checkDate = this.store.getBoolean("MatchDate");
        this.checkCalcValuesLOR = this.store.getBoolean("CalcValuesLOR");
        this.checkCalcValuesDownFlux = this.store.getBoolean("CalcValuesDownFlux");
        this.checkCalcValuesDFF = this.store.getBoolean("CalcValuesDFF");
        this.checkDFFpresent = this.store.getBoolean("CheckDFFPresent");
    }

    public Iterator<EulumdatChecker> iterator() {
        return this.checklist.iterator();
    }

    public boolean rebuildOnLampsChange() {
        return this.checkLampTypeKnown;
    }

    public String toString() {
        return "CheckerList [checklist=" + String.valueOf(this.checklist) + "]";
    }

    public void validateEulumdat(String fname, IEulumdatRO eu, ProblemReporter pr) {
        this.checklist.parallelStream().forEach(c -> {
            boolean bl = c.check(fname, eu, pr);
        });
    }
}

