/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator.builder;

import com.fold1.data.Eulumdat2;
import com.fold1.data.EulumdatFactory;
import com.fold1.data.IEulumdat;
import com.fold1.data.IEulumdatRO;
import com.fold1.eulumdat.tools.decorators.AbstractEulumdatDecorator;
import com.fold1.eulumdat.tools.decorators.ProblemDecorator;
import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.participant.EulumdatValidatorParticipantsManager;
import com.fold1.eulumdat.tools.participant.PreflightChecker;
import com.fold1.eulumdat.tools.participant.ValidatorBuildParticipant;
import com.fold1.eulumdat.tools.properties.EulumdatProperty;
import com.fold1.eulumdat.tools.utils.BuilderUtils;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.eulumdat.tools.validator.builder.EulumdatProblemReporter;
import com.fold1.eulumdat.tools.validator.builder.PropertyBuilder;
import com.fold1.eulumdat.tools.validator.checker.CheckerList;
import com.fold1.eulumdat.tools.validator.visitor.CountingResourceVisitor;
import com.fold1.eulumdat.tools.validator.visitor.CountingTester;
import com.fold1.exceptions.ParserException;
import com.fold1.util.Stopwatch;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class EulumdatValidatorBuilder
extends IncrementalProjectBuilder {
    private static final String PARTICIPANTS_PREFERENCE_PAGE = "com.fold1.eulumdat.tools.sandbox.preference.ParticipantsPreferencePage";
    CheckerList checkers;
    private final CountingTester eulumdatCounterTester;
    private List<ValidatorBuildParticipant> participants;
    private IProgressMonitor progress = new NullProgressMonitor();

    private static void cleanEulumdat(IResource resource) {
        IFile file = null;
        if (resource instanceof IFile) {
            file = (IFile)resource;
            BuilderUtils.deleteMarkers((IResource)file, (String)"com.fold1.eulumdat.tools.validator.eulumdatProblem");
            AbstractEulumdatDecorator.refresh((AbstractEulumdatDecorator)ProblemDecorator.getDecoratorInstance(), (IResource)file);
            try {
                Object p = file.getSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY);
                if (p != null) {
                    file.setSessionProperty(EulumdatProperty.EULUMDAT_PROPKEY, null);
                }
            }
            catch (CoreException e) {
                Logger.logError((String)("Error occurred during cleaning " + resource.getName()), (Throwable)e);
            }
        }
    }

    public EulumdatValidatorBuilder() {
        this.eulumdatCounterTester = r -> Utils.isEulumdat((String)r.getName());
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        block11: {
            this.extensionsGetActive();
            if (this.checkers != null) {
                this.checkers.clear();
            }
            this.checkers = new CheckerList(this.getProject());
            if (Platform.inDevelopmentMode()) {
                System.out.println("EulumdatValidatorBuilder.build() " + this.getProject().getName() + "|" + kind + " with " + this.checkers.toString());
            }
            if (kind == 6) {
                ResourcesPlugin.getWorkspace().run(m -> this.fullEulumdatBuild(m), (ISchedulingRule)this.getProject(), 1, monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    ResourcesPlugin.getWorkspace().run(m -> this.fullEulumdatBuild(m), (ISchedulingRule)this.getProject(), 1, monitor);
                } else if (this.checkers.rebuildOnLampsChange()) {
                    try {
                        ContainsResourceVisitor converter = new ContainsResourceVisitor("converter.lamps");
                        delta.accept((IResourceDeltaVisitor)converter);
                        if (converter.isLamplist()) {
                            ResourcesPlugin.getWorkspace().run(m -> this.fullEulumdatBuild(m), (ISchedulingRule)this.getProject(), 1, monitor);
                            break block11;
                        }
                        ResourcesPlugin.getWorkspace().run(m -> this.incrementalEulumdatBuild(delta, m), (ISchedulingRule)this.getProject(), 1, monitor);
                    }
                    catch (CoreException e) {
                        EulumdatValidatorLogger.logError("Problem preparing build", e);
                    }
                } else {
                    ResourcesPlugin.getWorkspace().run(m -> this.incrementalEulumdatBuild(delta, m), (ISchedulingRule)this.getProject(), 1, monitor);
                }
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        try {
            ResourcesPlugin.getWorkspace().run(m -> BuilderUtils.deleteMarkers((IResource)this.getProject(), (String)"com.fold1.eulumdat.tools.validator.eulumdatProblem"), (ISchedulingRule)this.getProject(), 1, monitor);
        }
        catch (CoreException e) {
            EulumdatValidatorLogger.logError("Problem doing clean build", e);
        }
    }

    private void extendPostFile(IFile file, Eulumdat2 eu, IProgressMonitor monitor) {
        boolean result = false;
        for (ValidatorBuildParticipant participant : this.participants) {
            result |= participant.postFile(file, (IEulumdat)eu, monitor);
        }
    }

    private void extendPostProject(IProgressMonitor monitor) {
        boolean result = false;
        for (ValidatorBuildParticipant participant : this.participants) {
            result |= participant.postProject(this.getProject(), monitor);
        }
    }

    private boolean extendPreFile(IFile file, Eulumdat2 eu, IProgressMonitor monitor) {
        boolean result = false;
        for (ValidatorBuildParticipant participant : this.participants) {
            result |= participant.preFile(file, (IEulumdat)eu, monitor);
        }
        return result;
    }

    private boolean extendPreProject(IProgressMonitor monitor) {
        boolean result = false;
        for (ValidatorBuildParticipant participant : this.participants) {
            result |= participant.preProject(this.getProject(), monitor);
        }
        return result;
    }

    private void extensionsGetActive() {
        this.participants = new ArrayList<ValidatorBuildParticipant>();
        this.participants.add(PreflightChecker.getInstance());
        this.participants.addAll(EulumdatValidatorParticipantsManager.getInstance().getActiveParticipants(this.getProject(), PARTICIPANTS_PREFERENCE_PAGE));
    }

    protected void fullEulumdatBuild(IProgressMonitor monitor) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        int count = 0;
        try {
            try {
                this.progress = monitor;
                if (this.getProject().isAccessible() && !this.extendPreProject(monitor)) {
                    CountingResourceVisitor counter = new CountingResourceVisitor(monitor, this.eulumdatCounterTester);
                    this.getProject().accept((IResourceProxyVisitor)counter, 0);
                    count = counter.getCount();
                    this.progress.beginTask("Validating (full) EULUMDAT files in " + this.getProject().getName(), count);
                    this.getProject().accept((IResourceVisitor)new BuildResourceVisitor());
                }
            }
            catch (CoreException e) {
                EulumdatValidatorLogger.logError("Problem doing full EULUMDAT build on '" + this.getProject().getName() + "'", e);
                this.progress = monitor;
                if (this.getProject().isAccessible()) {
                    this.extendPostProject(monitor);
                }
                stopwatch.stop();
                String message = "Completed full EULUMDAT build of '" + this.getProject().getName() + "' " + count + " files in " + stopwatch.getElapsed();
                EulumdatValidatorLogger.logInfo(message);
                this.progress.done();
            }
        }
        finally {
            this.progress = monitor;
            if (this.getProject().isAccessible()) {
                this.extendPostProject(monitor);
            }
            stopwatch.stop();
            String message = "Completed full EULUMDAT build of '" + this.getProject().getName() + "' " + count + " files in " + stopwatch.getElapsed();
            EulumdatValidatorLogger.logInfo(message);
            this.progress.done();
        }
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        return this.getProject();
    }

    protected void incrementalEulumdatBuild(IResourceDelta delta, IProgressMonitor monitor) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        int count = 0;
        try {
            try {
                if (!this.extendPreProject(monitor)) {
                    this.progress = monitor;
                    count = delta.getAffectedChildren().length;
                    this.progress.beginTask("Validating (incremental) EULUMDAT files in " + this.getProject().getName(), count);
                    delta.accept((IResourceDeltaVisitor)new BuildDeltaVisitor());
                }
            }
            catch (CoreException e) {
                EulumdatValidatorLogger.logError("Problem doing incremental EULUMDAT build on '" + this.getProject().getName() + "'", e);
                if (this.getProject().isAccessible()) {
                    this.extendPostProject(monitor);
                }
                this.progress.done();
                stopwatch.stop();
                EulumdatValidatorLogger.logInfo("Completed incremental EULUMDAT build of '" + this.getProject().getName() + "' " + count + " files in " + stopwatch.getElapsed());
            }
        }
        finally {
            if (this.getProject().isAccessible()) {
                this.extendPostProject(monitor);
            }
            this.progress.done();
            stopwatch.stop();
            EulumdatValidatorLogger.logInfo("Completed incremental EULUMDAT build of '" + this.getProject().getName() + "' " + count + " files in " + stopwatch.getElapsed());
        }
    }

    private void processEulumdat(IResource resource) {
        IFile file = null;
        if (!Utils.isEulumdat((IResource)resource)) {
            return;
        }
        EulumdatValidatorBuilder.cleanEulumdat(resource);
        file = (IFile)resource;
        EulumdatProblemReporter pr = new EulumdatProblemReporter(file);
        try {
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            EulumdatValidatorLogger.logError("Problem refreshing file system: " + e.getMessage(), e);
        }
        try {
            Throwable e = null;
            Object var5_11 = null;
            try (InputStream contents = file.getContents();){
                Eulumdat2 eu = EulumdatFactory.eulumdatFromInputStream((InputStream)contents, (String)resource.getName());
                if (!this.extendPreFile(file, eu, this.progress)) {
                    PropertyBuilder.addProperties(file, eu);
                    this.checkers.validateEulumdat(file.getName(), (IEulumdatRO)eu, pr);
                }
                this.extendPostFile(file, eu, this.progress);
                AbstractEulumdatDecorator.refresh((AbstractEulumdatDecorator)ProblemDecorator.getDecoratorInstance(), (IResource)file);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (ParserException e) {
            pr.report(e.getMessage(), e.getLineNumber(), 2, Eulumdat2.class.getName());
        }
        catch (AssertionError e) {
            EulumdatValidatorLogger.logError("Assertion Problem parsing Eulumdat: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
        catch (IOException e) {
            EulumdatValidatorLogger.logError("IO Problem parsing Eulumdat: " + e.getMessage(), e);
        }
        catch (CoreException e) {
            EulumdatValidatorLogger.log(e.getStatus());
        }
    }

    class BuildDeltaVisitor
    implements IResourceDeltaVisitor {
        BuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (EulumdatValidatorBuilder.this.progress.isCanceled() || EulumdatValidatorBuilder.this.isInterrupted()) {
                return false;
            }
            IResource resource = delta.getResource();
            if (!(resource instanceof IFile)) {
                return true;
            }
            switch (delta.getKind()) {
                case 1: {
                    EulumdatValidatorBuilder.this.progress.subTask(resource.getName());
                    EulumdatValidatorBuilder.this.processEulumdat(resource);
                    EulumdatValidatorBuilder.this.progress.worked(1);
                    break;
                }
                case 4: {
                    EulumdatValidatorBuilder.this.progress.subTask(resource.getName());
                    int flags = delta.getFlags();
                    if ((flags & 0x100) == 0 && (flags & 0x40000) == 0) break;
                    EulumdatValidatorBuilder.this.processEulumdat(resource);
                    EulumdatValidatorBuilder.this.progress.worked(1);
                    break;
                }
                case 2: {
                    break;
                }
            }
            return false;
        }
    }

    class BuildResourceVisitor
    implements IResourceVisitor {
        BuildResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            if (EulumdatValidatorBuilder.this.progress.isCanceled() || EulumdatValidatorBuilder.this.isInterrupted()) {
                return false;
            }
            if (!(resource instanceof IFile)) {
                return true;
            }
            EulumdatValidatorBuilder.this.progress.subTask(" checking " + resource.getName());
            EulumdatValidatorBuilder.this.processEulumdat(resource);
            EulumdatValidatorBuilder.this.progress.worked(1);
            return false;
        }
    }

    class ContainsResourceVisitor
    implements IResourceDeltaVisitor {
        private boolean lamplist = false;
        private final String match;

        public ContainsResourceVisitor(String match) {
            this.match = match;
        }

        public boolean isLamplist() {
            return this.lamplist;
        }

        public boolean visit(IResourceDelta resource) {
            if (EulumdatValidatorBuilder.this.progress.isCanceled() || this.lamplist || EulumdatValidatorBuilder.this.isInterrupted()) {
                return false;
            }
            if (resource != null && resource.getResource() instanceof IFile) {
                IFile file = (IFile)resource.getResource();
                if (file.getName().equals(this.match)) {
                    this.lamplist = true;
                }
                return false;
            }
            return true;
        }
    }
}

