/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class SWTResourceManager {
    private static Map<RGB, Color> mcolorMap = new HashMap<RGB, Color>();
    private static Map<String, Image> mimageMap = new HashMap<String, Image>();
    private static final int MISSINGIMAGESIZE = 10;
    public static final int TOPLEFT = 1;
    public static final int TOPRIGHT = 2;
    public static final int BOTTOMLEFT = 3;
    public static final int BOTTOMRIGHT = 4;
    protected static final int LASTCORNERKEY = 5;
    private static Map<Image, Map<Image, Image>>[] mdecoratedImageMap = new Map[5];
    private static Map<String, Font> mfontMap = new HashMap<String, Font>();
    private static Map<Font, Font> mfontToBoldFontMap = new HashMap<Font, Font>();
    private static Map<Integer, Cursor> midToCursorMap = new HashMap<Integer, Cursor>();

    public static Color getColor(int systemColorID) {
        Display display = Display.getCurrent();
        return display.getSystemColor(systemColorID);
    }

    public static Color getColor(int r, int g, int b) {
        return SWTResourceManager.getColor(new RGB(r, g, b));
    }

    public static Color getColor(RGB rgb) {
        Color color = mcolorMap.get(rgb);
        if (color == null) {
            Display display = Display.getCurrent();
            color = new Color((Device)display, rgb);
            mcolorMap.put(rgb, color);
        }
        return color;
    }

    public static void disposeColors() {
        for (Color color : mcolorMap.values()) {
            color.dispose();
        }
        mcolorMap.clear();
    }

    protected static Image getImage(InputStream stream) throws IOException {
        try {
            Display display = Display.getCurrent();
            ImageData data = new ImageData(stream);
            if (data.transparentPixel > 0) {
                Image image = new Image((Device)display, data, data.getTransparencyMask());
                return image;
            }
            Image image = new Image((Device)display, data);
            return image;
        }
        finally {
            stream.close();
        }
    }

    public static Image getImage(String path) {
        Image image = mimageMap.get(path);
        if (image == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream stream = new FileInputStream(path);){
                    image = SWTResourceManager.getImage(stream);
                    mimageMap.put(path, image);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                image = SWTResourceManager.getMissingImage();
                mimageMap.put(path, image);
            }
        }
        return image;
    }

    public static Image getBundleImage(Bundle b, String path) {
        Image image = mimageMap.get(path);
        if (image == null) {
            try {
                image = SWTResourceManager.getImage(FileLocator.openStream((Bundle)b, (IPath)new Path(path), (boolean)false));
                mimageMap.put(path, image);
            }
            catch (Exception e) {
                image = SWTResourceManager.getMissingImage();
                mimageMap.put(path, image);
            }
        }
        return image;
    }

    public static Image getImage(Class<?> clazz, String path) {
        String key = clazz.getName() + "|" + path;
        Image image = mimageMap.get(key);
        if (image == null) {
            try {
                image = SWTResourceManager.getImage(clazz.getResourceAsStream(path));
                mimageMap.put(key, image);
            }
            catch (Exception e) {
                image = SWTResourceManager.getMissingImage();
                mimageMap.put(key, image);
            }
        }
        return image;
    }

    private static Image getMissingImage() {
        Image image = new Image((Device)Display.getCurrent(), 10, 10);
        GC gc = new GC((Drawable)image);
        gc.setBackground(SWTResourceManager.getColor(3));
        gc.fillRectangle(0, 0, 10, 10);
        gc.dispose();
        return image;
    }

    public static Image decorateImage(Image baseImage, Image decorator) {
        return SWTResourceManager.decorateImage(baseImage, decorator, 4);
    }

    public static Image decorateImage(Image baseImage, Image decorator, int corner) {
        Image result;
        Map<Image, Image> decoratedMap;
        if (corner <= 0 || corner >= 5) {
            throw new IllegalArgumentException("Wrong decorate corner");
        }
        Map<Image, Map<Image, Image>> cornerDecoratedImageMap = mdecoratedImageMap[corner];
        if (cornerDecoratedImageMap == null) {
            SWTResourceManager.mdecoratedImageMap[corner] = cornerDecoratedImageMap = new HashMap<Image, Map<Image, Image>>();
        }
        if ((decoratedMap = cornerDecoratedImageMap.get(baseImage)) == null) {
            decoratedMap = new HashMap<Image, Image>();
            cornerDecoratedImageMap.put(baseImage, decoratedMap);
        }
        if ((result = decoratedMap.get(decorator)) == null) {
            Rectangle bib = baseImage.getBounds();
            Rectangle dib = decorator.getBounds();
            result = new Image((Device)Display.getCurrent(), bib.width, bib.height);
            GC gc = new GC((Drawable)result);
            gc.drawImage(baseImage, 0, 0);
            if (corner == 1) {
                gc.drawImage(decorator, 0, 0);
            } else if (corner == 2) {
                gc.drawImage(decorator, bib.width - dib.width, 0);
            } else if (corner == 3) {
                gc.drawImage(decorator, 0, bib.height - dib.height);
            } else if (corner == 4) {
                gc.drawImage(decorator, bib.width - dib.width, bib.height - dib.height);
            }
            gc.dispose();
            decoratedMap.put(decorator, result);
        }
        return result;
    }

    public static void disposeImages() {
        for (Image image : mimageMap.values()) {
            image.dispose();
        }
        mimageMap.clear();
        Map<Image, Map<Image, Image>>[] mapArray = mdecoratedImageMap;
        int n = mdecoratedImageMap.length;
        int n2 = 0;
        while (n2 < n) {
            Map<Image, Map<Image, Image>> cornerDecoratedImageMap = mapArray[n2];
            if (cornerDecoratedImageMap != null) {
                for (Map<Image, Image> decoratedMap : cornerDecoratedImageMap.values()) {
                    for (Image image : decoratedMap.values()) {
                        image.dispose();
                    }
                    decoratedMap.clear();
                }
                cornerDecoratedImageMap.clear();
            }
            ++n2;
        }
    }

    public static Font getFont(String name, int height, int style) {
        return SWTResourceManager.getFont(name, height, style, false, false);
    }

    public static Font getFont(String name, int size, int style, boolean strikeout, boolean underline) {
        String fontName = name + "|" + size + "|" + style + "|" + strikeout + "|" + underline;
        Font font = mfontMap.get(fontName);
        if (font == null) {
            FontData fontData = new FontData(name, size, style);
            if (strikeout || underline) {
                try {
                    Class<?> logFontClass = Class.forName("org.eclipse.swt.internal.win32.LOGFONT");
                    Object logFont = FontData.class.getField("data").get(fontData);
                    if (logFont != null && logFontClass != null) {
                        if (strikeout) {
                            logFontClass.getField("lfStrikeOut").set(logFont, (byte)1);
                        }
                        if (underline) {
                            logFontClass.getField("lfUnderline").set(logFont, (byte)1);
                        }
                    }
                }
                catch (Throwable e) {
                    System.err.println("Unable to set underline or strikeout (probably on a non-Windows platform). " + String.valueOf(e));
                }
            }
            font = new Font((Device)Display.getCurrent(), fontData);
            mfontMap.put(fontName, font);
        }
        return font;
    }

    public static Font getBoldFont(Font baseFont) {
        Font font = mfontToBoldFontMap.get(baseFont);
        if (font == null) {
            FontData[] fontDatas = baseFont.getFontData();
            FontData data = fontDatas[0];
            font = new Font((Device)Display.getCurrent(), data.getName(), data.getHeight(), 1);
            mfontToBoldFontMap.put(baseFont, font);
        }
        return font;
    }

    public static void disposeFonts() {
        for (Font font : mfontMap.values()) {
            font.dispose();
        }
        mfontMap.clear();
        for (Font font : mfontToBoldFontMap.values()) {
            font.dispose();
        }
        mfontToBoldFontMap.clear();
    }

    public static Cursor getCursor(int id) {
        Integer key = id;
        Cursor cursor = midToCursorMap.get(key);
        if (cursor == null) {
            cursor = new Cursor((Device)Display.getDefault(), id);
            midToCursorMap.put(key, cursor);
        }
        return cursor;
    }

    public static void disposeCursors() {
        for (Cursor cursor : midToCursorMap.values()) {
            cursor.dispose();
        }
        midToCursorMap.clear();
    }

    public static void dispose() {
        SWTResourceManager.disposeColors();
        SWTResourceManager.disposeImages();
        SWTResourceManager.disposeFonts();
        SWTResourceManager.disposeCursors();
    }
}

