/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.validator;

import com.fold1.eulumdat.tools.log.Logger;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public final class EulumdatMarkerUtils {
    public static void addMarker(IFile file, String message, int lineNumber, int charStart, int charEnd, int severity, String check, Object expected) {
        try {
            IMarker marker = file.createMarker("com.fold1.eulumdat.tools.validator.eulumdatProblem");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("message", message);
            attributes.put("severity", severity);
            attributes.put("check", check);
            if (lineNumber >= 0) {
                attributes.put("lineNumber", lineNumber);
            }
            if (charStart >= 0) {
                attributes.put("charStart", charStart);
            }
            if (charEnd >= 0) {
                attributes.put("charEnd", charEnd);
            }
            if (expected != null) {
                if (expected instanceof Map) {
                    Map exp = (Map)expected;
                    attributes.putAll(exp);
                } else if (expected instanceof String || expected instanceof Boolean || expected instanceof Integer) {
                    attributes.put("expected", expected);
                } else {
                    attributes.put("expected", expected.toString());
                }
            }
            marker.setAttributes(attributes);
        }
        catch (CoreException e) {
            Logger.logError((String)("Problem creating marker in " + file.getName()), (Throwable)e);
        }
    }

    public static void addMarker(IFile file, String message, int lineNumber, int severity, String check, Object expected) {
        try {
            IMarker marker = file.createMarker("com.fold1.eulumdat.tools.validator.eulumdatProblem");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("message", message.intern());
            attributes.put("severity", severity);
            attributes.put("check", check.intern());
            int line = lineNumber == -1 ? 1 : lineNumber;
            attributes.put("lineNumber", line);
            if (expected != null) {
                if (expected instanceof Map) {
                    attributes.putAll((Map)expected);
                } else if (expected instanceof String) {
                    attributes.put("expected", ((String)expected).intern());
                } else if (expected instanceof Boolean || expected instanceof Integer) {
                    attributes.put("expected", expected);
                } else {
                    attributes.put("expected", expected.toString());
                }
            }
            marker.setAttributes(attributes);
        }
        catch (CoreException e) {
            EulumdatValidatorLogger.logError("Problem creating marker in " + file.getName(), e);
        }
    }

    private EulumdatMarkerUtils() {
    }
}

