/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.participant;

import com.bdaum.overlaypages.OverlayUtils;
import com.fold1.eulumdat.tools.participant.ParticipantReference;
import com.fold1.eulumdat.tools.participant.ValidatorBuildParticipant;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;

public final class EulumdatValidatorParticipantsManager {
    private static final String ATT_CLASS = "class";
    private static final String ATT_ID = "id";
    private static final String ATT_PREFTEXT = "prefText";
    private static EulumdatValidatorParticipantsManager instance;
    Map<String, ParticipantReferenceImpl> participants = new HashMap<String, ParticipantReferenceImpl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EulumdatValidatorParticipantsManager getInstance() {
        EulumdatValidatorParticipantsManager r = instance;
        if (r != null) return instance;
        Class<EulumdatValidatorParticipantsManager> clazz = EulumdatValidatorParticipantsManager.class;
        synchronized (EulumdatValidatorParticipantsManager.class) {
            r = instance;
            if (r != null) return instance;
            r = new EulumdatValidatorParticipantsManager();
            r.gather();
            instance = r;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private EulumdatValidatorParticipantsManager() {
    }

    private void gather() {
        IExtension[] extensions;
        IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint("com.fold1.eulumdat.tools.validator", "buildParticipants").getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurationElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
            int n3 = configurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    String id = configurationElement.getAttribute(ATT_ID);
                    String prefText = configurationElement.getAttribute(ATT_PREFTEXT);
                    ValidatorBuildParticipant executableExtension = (ValidatorBuildParticipant)configurationElement.createExecutableExtension(ATT_CLASS);
                    ParticipantReferenceImpl ref = new ParticipantReferenceImpl(executableExtension, id, prefText);
                    this.participants.put(id, ref);
                }
                catch (CoreException e) {
                    EulumdatValidatorLogger.logError("Failed to instantiate " + configurationElement.getAttribute(ATT_CLASS) + " in plugin " + configurationElement.getDeclaringExtension().getNamespaceIdentifier(), e);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public List<ValidatorBuildParticipant> getActiveParticipants(IProject project, String pageID) {
        IPreferenceStore store = OverlayUtils.getStoreToUse((IResource)project, (String)pageID);
        ArrayList<ValidatorBuildParticipant> result = new ArrayList<ValidatorBuildParticipant>();
        for (ParticipantReference participantReference : this.participants.values()) {
            if (!store.getBoolean(participantReference.getId())) continue;
            result.add(participantReference.getExecutable());
        }
        return Collections.unmodifiableList(result);
    }

    public List<ParticipantReference> getAllParticipants() {
        return Collections.unmodifiableList(new ArrayList<ParticipantReferenceImpl>(this.participants.values()));
    }

    private static final class ParticipantReferenceImpl
    implements ParticipantReference {
        private final ValidatorBuildParticipant executable;
        private final String id;
        private final String prefText;

        private ParticipantReferenceImpl(ValidatorBuildParticipant executable, String id, String prefText) {
            this.executable = executable;
            this.id = id;
            this.prefText = prefText;
        }

        @Override
        public ValidatorBuildParticipant getExecutable() {
            return this.executable;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getPrefText() {
            return this.prefText;
        }
    }
}

