/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.sandbox.visitor;

import com.fold1.data.Eulumdat2;
import com.fold1.data.EulumdatFactory;
import com.fold1.data.IEulumdatRO;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.validator.EulumdatValidatorLogger;
import com.fold1.exceptions.ParserException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class OverlappingCPlanesRemoverVisistor
implements IResourceVisitor {
    private static final String ERROR_WHILE_FIXING = "Error while fixing overlappin C-plane at 0\u00b0 and 360\u00b0 ";
    private IProgressMonitor monitor;

    public OverlappingCPlanesRemoverVisistor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (Utils.isEulumdat((IResource)resource)) {
            IFile file = (IFile)resource;
            if (this.monitor != null) {
                this.monitor.subTask("Changing " + file.getName());
            }
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (BufferedInputStream contents = new BufferedInputStream(file.getContents());){
                    Eulumdat2 eu = EulumdatFactory.eulumdatFromInputStream((InputStream)contents, (String)file.getName());
                    ((InputStream)contents).close();
                    IEulumdatRO ro = EulumdatFactory.eulumdatROTidy((IEulumdatRO)eu, (boolean)false, (boolean)true);
                    ByteArrayInputStream source = new ByteArrayInputStream(ro.toString().getBytes("UTF-8"));
                    file.setContents((InputStream)source, true, true, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ParserException | IOException e) {
                throw new CoreException(EulumdatValidatorLogger.createStatus((int)4, (int)0, (String)ERROR_WHILE_FIXING, (Throwable)e));
            }
            return false;
        }
        return !(resource instanceof IFile);
    }
}

