/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.sandbox.preference;

import com.bdaum.overlaypages.FieldEditorOverlayPage;
import com.fold1.eulumdat.tools.participant.EulumdatValidatorParticipantsManager;
import com.fold1.eulumdat.tools.participant.ParticipantReference;
import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import com.fold1.eulumdat.tools.sandbox.Logger;
import com.fold1.eulumdat.tools.utils.BuilderUtils;
import com.fold1.eulumdat.tools.utils.Rebuilder;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ParticipantsPreferencePage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.fold1.eulumdat.tools.sandbox.preference.ParticipantsPreferencePage";

    public ParticipantsPreferencePage() {
        super(1);
        this.setPreferenceStore(EulumdatToolsPreferences.getStore());
        this.setDescription("Use the options below to enable/disable validation participants");
    }

    protected void createFieldEditors() {
        List all = EulumdatValidatorParticipantsManager.getInstance().getAllParticipants();
        for (ParticipantReference ref : all) {
            this.addField((FieldEditor)new BooleanFieldEditor(ref.getId(), ref.getPrefText(), 0, this.getFieldEditorParent()));
        }
    }

    public void init(IWorkbench workbench) {
        this.setDescription("Experimental EULUMDAT Validator Settings");
    }

    protected String getPageId() {
        return ID;
    }

    public boolean performOk() {
        String builder;
        this.checkState();
        if (!this.isValid()) {
            return false;
        }
        Shell shell = this.getShell();
        boolean rebuild = MessageDialog.openQuestion((Shell)shell, (String)"Changes require rebuild", (String)"Your changes require a full rebuild. Perform this rebuild now?");
        try {
            builder = BuilderUtils.findBuilder((String)"com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature");
        }
        catch (CoreException e) {
            Logger.logError("Error finding builder for com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature", e);
            return false;
        }
        if (!rebuild) {
            return false;
        }
        Rebuilder rebuilder = null;
        if (this.isPropertyPage()) {
            IProject project = (IProject)this.getElement();
            rebuilder = new Rebuilder("Sandbox Change Project Rebuild", "com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature", builder, project);
        } else {
            rebuilder = new Rebuilder("Sandbox Change Workspace Rebuild", "com.fold1.eulumdat.tools.validator.eulumdatValidatorProjectNature", builder);
        }
        rebuilder.schedule(20L);
        return super.performOk();
    }
}

