/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.sandbox.participant;

import com.fold1.data.IEulumdat;
import com.fold1.eulumdat.tools.participant.AbstractValidatorBuildParticipant;
import com.fold1.eulumdat.tools.validator.EulumdatMarkerUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public class UniqueItemCode
extends AbstractValidatorBuildParticipant {
    public static final String ID = UniqueItemCode.class.getName();
    private static final int PRODUCT_CODE_LINENUMBER = 10;
    private Map<String, ItemReference> references;

    public synchronized boolean postProject(IProject project, IProgressMonitor monitor) {
        this.references.values().stream().filter(t -> t.getCount() > 1).forEach(t -> {
            ItemReference itemReference = t;
            synchronized (itemReference) {
                for (IFile f : t.getRefs()) {
                    String message = t.toMessage();
                    EulumdatMarkerUtils.addMarker((IFile)f, (String)message, (int)10, (int)2, (String)ID, null);
                }
            }
        });
        return false;
    }

    public boolean preFile(IFile file, IEulumdat eu, IProgressMonitor monitor) {
        String productCode = eu.getProductCode();
        if (this.references.containsKey(productCode)) {
            this.references.get(productCode).addReference(file);
        } else {
            this.references.put(productCode, new ItemReference(productCode, file));
        }
        return false;
    }

    public synchronized boolean preProject(IProject project, IProgressMonitor monitor) {
        this.references = new ConcurrentHashMap<String, ItemReference>();
        return false;
    }

    private class ItemReference {
        private final String item;
        private final Set<IFile> refs;

        ItemReference(String item, IFile file) {
            this.item = item;
            this.refs = new HashSet<IFile>();
            this.getRefs().add(file);
        }

        void addReference(IFile file) {
            this.getRefs().add(file);
        }

        int getCount() {
            return this.getRefs().size();
        }

        Set<IFile> getRefs() {
            return this.refs;
        }

        public String toMessage() {
            return "Identical Product Code '" + this.item + "' appears in " + this.getCount() + " files.";
        }
    }
}

