/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.sandbox.participant;

import com.fold1.data.IEulumdat;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.SphereUtils;
import com.fold1.data.Symmetry;
import com.fold1.eulumdat.tools.participant.AbstractValidatorBuildParticipant;
import com.fold1.eulumdat.tools.sandbox.Logger;
import com.fold1.eulumdat.tools.validator.EulumdatMarkerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.stat.StatUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class SymmetryOptimizer
extends AbstractValidatorBuildParticipant {
    public static final String ID = "com.fold1.eulumdat.tools.sandbox.participant.SymmetryOptimizer";
    private static final double THRESHOLD = 1.0E-5;
    private double mean_var;
    private double mean0_180;
    private double mean90_270;

    public Symmetry detectSymmetry(IEulumdatRO eu) {
        if (!Symmetry.NONE.equals((Object)eu.getIsym())) {
            throw new IllegalArgumentException(eu.getFileName() + " already has symmetry " + String.valueOf(eu.getIsym()));
        }
        double[] sym0_180 = new double[eu.getAnglesGammaNumber()];
        double[] sym90_270 = new double[eu.getAnglesGammaNumber()];
        double[] stddev = new double[eu.getAnglesGammaNumber()];
        double[] sliceWeight = SphereUtils.calcSlices((IEulumdatRO)eu);
        int gamma = 0;
        while (gamma < eu.getAnglesGammaNumber()) {
            double[] vector = new double[eu.getAnglesCNumber()];
            int c = 0;
            while (c < eu.getAnglesCNumber()) {
                vector[c] = eu.getValue(c, gamma);
                ++c;
            }
            double mean = StatUtils.mean((double[])vector);
            stddev[gamma] = 0.5 * sliceWeight[gamma] * Math.sqrt(StatUtils.variance((double[])vector)) / mean;
            List<Double> gPlane = Arrays.asList(ArrayUtils.toObject((double[])vector));
            List<Double> start = gPlane.subList(1, eu.getAnglesCNumber() / 2);
            List<Double> end = gPlane.subList(eu.getAnglesCNumber() / 2 + 1, eu.getAnglesCNumber());
            Collections.reverse(end);
            sym0_180[gamma] = 0.5 * sliceWeight[gamma] * StatUtils.meanDifference((double[])ArrayUtils.toPrimitive((Double[])start.toArray(new Double[0])), (double[])ArrayUtils.toPrimitive((Double[])end.toArray(new Double[0])));
            List<Double> p1 = gPlane.subList(0, eu.getAnglesCNumber() / 4);
            Collections.reverse(p1);
            List<Double> p23 = gPlane.subList(eu.getAnglesCNumber() / 4 + 1, 3 * eu.getAnglesCNumber() / 4);
            List<Double> p4 = gPlane.subList(3 * eu.getAnglesCNumber() / 4 + 1, eu.getAnglesCNumber());
            Collections.reverse(p4);
            ArrayList<Double> p14 = new ArrayList<Double>(p1);
            p14.addAll(p4);
            sym90_270[gamma] = 0.5 * sliceWeight[gamma] * StatUtils.meanDifference((double[])ArrayUtils.toPrimitive((Double[])p14.toArray(new Double[0])), (double[])ArrayUtils.toPrimitive((Double[])p23.toArray(new Double[0])));
            ++gamma;
        }
        this.mean_var = StatUtils.max((double[])stddev);
        this.mean0_180 = StatUtils.max((double[])sym0_180);
        this.mean90_270 = StatUtils.max((double[])sym90_270);
        if (this.mean_var < 1.0E-5 && this.mean90_270 < 1.0E-5 && this.mean0_180 < 1.0E-5) {
            return Symmetry.ROTATION;
        }
        if (this.mean90_270 < 1.0E-5 && this.mean0_180 < 1.0E-5) {
            return Symmetry.QUAD;
        }
        if (this.mean0_180 < 1.0E-5) {
            return Symmetry.C_0_180;
        }
        if (this.mean90_270 < 1.0E-5) {
            return Symmetry.C_90_270;
        }
        return Symmetry.NONE;
    }

    public boolean preFile(IFile file, IEulumdat eu, IProgressMonitor monitor) {
        if (Symmetry.NONE.equals((Object)eu.getIsym())) {
            SymmetryRunner code = new SymmetryRunner(file, (IEulumdatRO)eu);
            SafeRunner.run((ISafeRunnable)code);
            Symmetry expectedSymmetry = code.getSymmetry();
            if (!Symmetry.NONE.equals((Object)expectedSymmetry)) {
                EulumdatMarkerUtils.addMarker((IFile)file, (String)("File is defined as Symmetry.NONE but contains data with " + String.valueOf(expectedSymmetry) + this.toString()), (int)3, (int)1, (String)ID, (Object)expectedSymmetry);
            }
        }
        return false;
    }

    public String toString() {
        return String.format(" [ROT = %.6f, C0_180 = %.6f, C90_270 = %.6f]", this.mean_var, this.mean0_180, this.mean90_270);
    }

    private final class SymmetryRunner
    implements ISafeRunnable {
        private final IFile file;
        Symmetry symmetry = Symmetry.NONE;
        private final IEulumdatRO eu;

        private SymmetryRunner(IFile file, IEulumdatRO eu) {
            this.file = file;
            this.eu = eu;
        }

        public Symmetry getSymmetry() {
            return this.symmetry;
        }

        public void handleException(Throwable exception) {
            Logger.logError("Problem in " + String.valueOf(this.file.getLocation()), exception);
            this.symmetry = Symmetry.NONE;
        }

        public void run() throws Exception {
            this.symmetry = SymmetryOptimizer.this.detectSymmetry(this.eu);
        }
    }
}

