/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.sandbox.participant;

import com.fold1.data.IEulumdat;
import com.fold1.eulumdat.tools.participant.AbstractValidatorBuildParticipant;
import com.fold1.eulumdat.tools.sandbox.Logger;
import com.fold1.eulumdat.tools.validator.EulumdatMarkerUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class OverlappingCPlaneDetector
extends AbstractValidatorBuildParticipant {
    public static final String ID = "com.fold1.eulumdat.tools.sandbox.participant.OverlappingCPlaneDetector";

    public boolean preFile(IFile file, IEulumdat eu, IProgressMonitor monitor) {
        boolean result;
        try {
            result = eu.hasCplane360();
        }
        catch (Exception e) {
            result = true;
            Logger.log(4, 0, "OverlappingCPlaneDetector exception in " + file.getName(), e);
        }
        if (result) {
            int expected = eu.getNoCPlanes() - 1;
            EulumdatMarkerUtils.addMarker((IFile)file, (String)("Number of C-planes too large, overlap at 0\u00b0 and 360\u00b0. Expected : " + expected), (int)4, (int)2, (String)ID, (Object)expected);
            int errorLine = 26 + eu.getNumberOfLampSets() * 5 + eu.getNoCPlanes() + 10 + 1;
            EulumdatMarkerUtils.addMarker((IFile)file, (String)"C-plane at 360\u00b0 overlaps with one at 0\u00b0, remove!", (int)errorLine, (int)2, (String)ID, null);
        }
        return false;
    }
}

