/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.sandbox.participant;

import com.fold1.data.Eulumdat2;
import com.fold1.data.IEulumdat;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.SphereUtils;
import com.fold1.data.Symmetry;
import com.fold1.eulumdat.tools.participant.AbstractValidatorBuildParticipant;
import com.fold1.eulumdat.tools.validator.EulumdatMarkerUtils;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class CurbAimDetector
extends AbstractValidatorBuildParticipant {
    public static final String ID = "com.fold1.eulumdat.tools.sandbox.participant.CurbAimDetector";

    public boolean preFile(IFile file, IEulumdat eu, IProgressMonitor monitor) {
        if (Symmetry.C_90_270.equals((Object)eu.getIsym())) {
            ArrayRealVector weights = new ArrayRealVector(SphereUtils.calcSlices((IEulumdatRO)eu));
            int c90index = Eulumdat2.findCPlaneIndex((Eulumdat2)((Eulumdat2)eu), (double)90.0);
            ArrayRealVector c90 = new ArrayRealVector(eu.getValueCPlane(c90index));
            int c270index = Eulumdat2.findCPlaneIndex((Eulumdat2)((Eulumdat2)eu), (double)270.0);
            ArrayRealVector c270 = new ArrayRealVector(eu.getValueCPlane(c270index));
            if (c90.dotProduct((RealVector)weights) / c270.dotProduct((RealVector)weights) < 0.95) {
                EulumdatMarkerUtils.addMarker((IFile)file, (String)"File with Symmetry.C90_270 (streetlighting) has most flux towards C270 (curb side)", (int)3, (int)1, (String)ID, null);
            }
        }
        return false;
    }
}

