/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.sandbox.fixer;

import com.fold1.eulumdat.tools.sandbox.Logger;
import com.fold1.eulumdat.tools.sandbox.visitor.SymmetryReductionVisistor;
import com.fold1.eulumdat.tools.validator.fixer.AbstractEulumdatBackgroundProblemFixer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SymmetryReducer
extends AbstractEulumdatBackgroundProblemFixer {
    private IMarker originalMarker;

    public SymmetryReducer(IMarker marker) {
        this.originalMarker = marker;
    }

    public String getLabel() {
        String expected = this.originalMarker.getAttribute("expected", "ATTRIBUTE NOT FOUND_ATTR");
        return "Reduce to symmetry to " + expected;
    }

    protected boolean isValidOther(IMarker markerToCheck) {
        if (markerToCheck.equals((Object)this.originalMarker)) {
            return false;
        }
        if (!this.fullVersion && !markerToCheck.getResource().equals((Object)this.originalMarker.getResource())) {
            return false;
        }
        if (!markerToCheck.getResource().isAccessible()) {
            return false;
        }
        String checkerName = "com.fold1.eulumdat.tools.sandbox.participant.SymmetryOptimizer";
        if (!checkerName.equals(SymmetryReducer.getCheckerName((IMarker)markerToCheck))) {
            return false;
        }
        String expected = this.originalMarker.getAttribute("expected", "ATTRIBUTE NOT FOUND_ATTR");
        return markerToCheck.getAttribute("expected", "ATTRIBUTE NOT FOUND_ATTR").equals(expected);
    }

    protected void fixTheProblem(IMarker m, IProgressMonitor monitor) {
        String expected = this.originalMarker.getAttribute("expected", "ATTRIBUTE NOT FOUND_ATTR");
        try {
            m.getResource().accept((IResourceVisitor)new SymmetryReductionVisistor(expected, monitor));
        }
        catch (CoreException e) {
            Logger.logError("Error reducing Symmetry", e);
        }
    }
}

