/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.sandbox.fixer;

import com.fold1.eulumdat.tools.sandbox.Logger;
import com.fold1.eulumdat.tools.sandbox.visitor.OverlappingCPlanesRemoverVisistor;
import com.fold1.eulumdat.tools.validator.fixer.AbstractEulumdatBackgroundProblemFixer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class OverlappingCPlanesRemover
extends AbstractEulumdatBackgroundProblemFixer {
    private IMarker originalMarker;

    public OverlappingCPlanesRemover(IMarker marker) {
        this.originalMarker = marker;
    }

    public String getLabel() {
        String expected = this.originalMarker.getAttribute("expected", "ATTRIBUTE NOT FOUND_ATTR");
        return "remove C-Plane for 360\u00b0 (last one) and reduce count to " + expected;
    }

    protected void fixTheProblem(IMarker m, IProgressMonitor monitor) {
        try {
            m.getResource().accept((IResourceVisitor)new OverlappingCPlanesRemoverVisistor(monitor));
        }
        catch (CoreException e) {
            Logger.logError("Error fixing Overlapping C-planes", e);
        }
    }

    protected boolean isValidOther(IMarker markerToCheck) {
        if (markerToCheck.equals((Object)this.originalMarker)) {
            return false;
        }
        boolean valid = false;
        try {
            valid = this.originalMarker.getAttribute("check").equals(markerToCheck.getAttribute("check"));
        }
        catch (CoreException e) {
            return false;
        }
        return valid;
    }
}

