/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.sandbox.compare;

import com.fold1.data.Eulumdat2;
import com.fold1.data.EulumdatFactory;
import com.fold1.eulumdat.tools.sandbox.compare.EulumdatStructureComparator;
import com.fold1.exceptions.ParserException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.runtime.CoreException;

public class EulumdatStructureCreator
implements IStructureCreator {
    public String getName() {
        return "EULUMDAT Structure Compare";
    }

    public IStructureComparator getStructure(Object input) {
        System.out.println("EulumdatStructureCreator.getStructure() " + String.valueOf(input));
        if (input instanceof ResourceNode) {
            ResourceNode node = (ResourceNode)input;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream contents = node.getContents();){
                    Eulumdat2 eu = EulumdatFactory.eulumdatFromInputStream((InputStream)contents, (String)node.getName());
                    return new EulumdatStructureComparator(eu, node.getModificationDate());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ParserException | IOException | CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public IStructureComparator locate(Object path, Object input) {
        System.out.println("EulumdatStructureCreator.locate() " + String.valueOf(path) + ", " + String.valueOf(input));
        return null;
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        System.out.println("EulumdatStructureCreator.getContents() " + String.valueOf(node));
        return null;
    }

    public void save(IStructureComparator node, Object input) {
        System.out.println("EulumdatStructureCreator.save() " + String.valueOf(node) + ", " + String.valueOf(input));
    }
}

