/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.sandbox.compare;

import com.fold1.data.Eulumdat2;
import com.fold1.data.ICGamma;
import com.fold1.eulumdat.tools.EulumdatToolsActivator;
import com.fold1.eulumdat.tools.sandbox.compare.CPlaneCompareItem;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.util.NumberOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;

public class CGammaStructureComparator
implements IStructureComparator,
ITypedElement,
IStreamContentAccessor {
    private Eulumdat2 eu;
    private long modification;

    public CGammaStructureComparator(Eulumdat2 eu, long modification) {
        this.eu = eu;
        this.modification = modification;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public Object[] getChildren() {
        ArrayList<CPlaneCompareItem> items = new ArrayList<CPlaneCompareItem>();
        ArrayList labels = Utils.createCPlaneLabels((ICGamma)this.eu);
        int i = 0;
        while (i < labels.size()) {
            CPlaneCompareItem item = new CPlaneCompareItem((String)labels.get(i), this.format(this.eu.getRawValueCPlane(i)), this.modification);
            items.add(item);
            ++i;
        }
        return items.toArray();
    }

    private String format(double[] valueCPlane) {
        StringBuffer b = new StringBuffer();
        double[] dArray = valueCPlane;
        int n = valueCPlane.length;
        int n2 = 0;
        while (n2 < n) {
            double element = dArray[n2];
            b.append(NumberOutput.digits((double)element, (int)1));
            b.append("\n");
            ++n2;
        }
        return b.toString();
    }

    public String getName() {
        return "CGamma";
    }

    public Image getImage() {
        return EulumdatToolsActivator.getEulumdatIcon();
    }

    public String getType() {
        return "txt";
    }

    public InputStream getContents() throws CoreException {
        return new ByteArrayInputStream(this.eu.toString().getBytes());
    }
}

