/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.refactor.handlers;

import com.fold1.data.EulumdatRefactory;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.Symmetry;
import com.fold1.eulumdat.tools.refactor.handlers.AbstractEulumdatRefactorHandler;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IParameterValues;

public class RotateHandler
extends AbstractEulumdatRefactorHandler
implements IParameterValues {
    private static Map<String, String> parameterValues = new HashMap<String, String>();
    private static final String ROT180 = "ROT180";
    private static final String ROT90CCW = "ROT90CCW";
    private static final String ROT90CW = "ROT90CW";
    private static final String ROTATION = "com.fold1.eulumdat.tools.refactor.rotation";

    static {
        parameterValues.put("90\u00b0 clockwise", ROT90CW);
        parameterValues.put("90\u00b0 counter-clockwise", ROT90CCW);
        parameterValues.put("180\u00b0", ROT180);
    }

    public Map<String, String> getParameterValues() {
        return parameterValues;
    }

    public boolean isEnabled() {
        if (this.symmetry == null) {
            return super.isEnabled();
        }
        return Symmetry.NONE.equals((Object)this.symmetry);
    }

    @Override
    protected IEulumdatRO performRefactoring(ExecutionEvent event, IEulumdatRO src) {
        String rotation = event.getParameter(ROTATION);
        IEulumdatRO eu = src;
        switch (rotation) {
            case "ROT90CW": {
                eu = EulumdatRefactory.rotate90CW((IEulumdatRO)src);
                break;
            }
            case "ROT90CCW": {
                eu = EulumdatRefactory.rotate90CCW((IEulumdatRO)src);
                break;
            }
            case "ROT180": {
                eu = EulumdatRefactory.rotate180((IEulumdatRO)src);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown rotation parameter received, got '" + rotation + "'");
            }
        }
        return eu;
    }
}

