/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.refactor.handlers;

import com.fold1.data.EulumdatRefactory;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.Symmetry;
import com.fold1.eulumdat.tools.refactor.handlers.AbstractEulumdatRefactorHandler;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IParameterValues;

public class ReduceHandler
extends AbstractEulumdatRefactorHandler
implements IParameterValues {
    private static final String DESIRED_SYMMETRY = "com.fold1.eulumdat.tools.refactor.desiredSymmetry";
    private static Map<String, String> parameterValues = new HashMap<String, String>();

    static {
        parameterValues.put("Rotation", Symmetry.ROTATION.toString());
        parameterValues.put("Over C0-C180", Symmetry.C_0_180.toString());
        parameterValues.put("Over C90-C270", Symmetry.C_90_270.toString());
        parameterValues.put("Over C0-C180 and C90-C270", Symmetry.QUAD.toString());
    }

    public Map<String, String> getParameterValues() {
        return parameterValues;
    }

    public boolean isEnabled() {
        if (this.symmetry == null) {
            return super.isEnabled();
        }
        return Symmetry.NONE.equals((Object)this.symmetry);
    }

    @Override
    protected IEulumdatRO performRefactoring(ExecutionEvent event, IEulumdatRO src) {
        String desired = event.getParameter(DESIRED_SYMMETRY);
        Symmetry symmetry1 = Symmetry.getSymmetry((int)Symmetry.symmetryFromString((String)desired));
        IEulumdatRO eu = EulumdatRefactory.reduce((IEulumdatRO)src, (Symmetry)symmetry1);
        return eu;
    }
}

