/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.refactor.handlers;

import com.fold1.data.EulumdatRefactory;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.Symmetry;
import com.fold1.eulumdat.tools.refactor.handlers.AbstractEulumdatRefactorHandler;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IParameterValues;

public class MirrorHandler
extends AbstractEulumdatRefactorHandler
implements IParameterValues {
    private static final String MIRROR = "com.fold1.eulumdat.tools.refactor.mirror";
    private static final String MIRRORC0C180 = "MIRRORC0C180";
    private static final String MIRRORC90C270 = "MIRRORC90C270";
    private static Map<String, String> parameterValues = new HashMap<String, String>();

    static {
        parameterValues.put("Mirror over C0-C180", MIRRORC0C180);
        parameterValues.put("Mirror over C90-C270", MIRRORC90C270);
    }

    public Map<String, String> getParameterValues() {
        return parameterValues;
    }

    public boolean isEnabled() {
        if (this.symmetry == null) {
            return super.isEnabled();
        }
        return Symmetry.NONE.equals((Object)this.symmetry);
    }

    @Override
    protected IEulumdatRO performRefactoring(ExecutionEvent event, IEulumdatRO src) {
        String mirror = event.getParameter(MIRROR);
        IEulumdatRO eu = src;
        switch (mirror) {
            case "MIRRORC0C180": {
                eu = EulumdatRefactory.mirrorC0C180((IEulumdatRO)src);
                break;
            }
            case "MIRRORC90C270": {
                eu = EulumdatRefactory.mirrorC90C270((IEulumdatRO)src);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mirror parameter received, got '" + mirror + "'");
            }
        }
        return eu;
    }
}

