/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.refactor.handlers;

import com.fold1.data.Eulumdat2;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.Symmetry;
import com.fold1.eulumdat.tools.editors.eulumdat.EulumdatEditor;
import com.fold1.eulumdat.tools.refactor.RefreshSourceProvider;
import com.fold1.eulumdat.tools.sandbox.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.ISourceProviderService;

public abstract class AbstractEulumdatRefactorHandler
extends AbstractHandler {
    protected Symmetry symmetry;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (editor instanceof EulumdatEditor) {
            EulumdatEditor eulumdatEditor = (EulumdatEditor)editor;
            try {
                Eulumdat2 eu = eulumdatEditor.getEulumdat();
                eu = this.performRefactoring(event, (IEulumdatRO)eu);
                eulumdatEditor.setEulumdat((IEulumdatRO)eu);
                this.performMenuRefresh(event, eu.getIsym().toString());
            }
            catch (IllegalArgumentException e) {
                Logger.logError("An error occured during refactoring", e);
            }
        }
        return null;
    }

    private void performMenuRefresh(ExecutionEvent event, String val) {
        ISourceProviderService sourceProviderService = (ISourceProviderService)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(ISourceProviderService.class);
        RefreshSourceProvider commandStateService = (RefreshSourceProvider)sourceProviderService.getSourceProvider("com.fold1.eulumdat.tools.refactor.refresh");
        commandStateService.refresh(val);
    }

    protected abstract IEulumdatRO performRefactoring(ExecutionEvent var1, IEulumdatRO var2);

    public void setEnabled(Object evaluationContext) {
        EulumdatEditor editor;
        EvaluationContext context;
        Object part;
        if (evaluationContext instanceof EvaluationContext && (part = (context = (EvaluationContext)evaluationContext).getVariable("activeEditor")) instanceof EulumdatEditor && (editor = (EulumdatEditor)part).getEulumdat() != null) {
            this.symmetry = editor.getEulumdat().getIsym();
        }
        super.setEnabled(evaluationContext);
    }
}

