/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.wizards;

import com.fold1.eulumdat.tools.handler.AddRemoveNatureHandler;
import com.fold1.eulumdat.tools.handler.CreateConverterLampsHandler;
import com.fold1.eulumdat.tools.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class NewEulumdatProjectWizard
extends Wizard
implements INewWizard {
    private static final String PROJECTPAGE = "new project page";
    private WizardNewProjectCreationPage mainPage;
    private IProject newProject;

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject newProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        IRunnableWithProgress op = monitor -> {
            CreateProjectOperation operation = new CreateProjectOperation(description, ResourceMessages.NewProject_windowTitle);
            try {
                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)operation, monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
            }
            catch (ExecutionException e) {
                throw new InvocationTargetException(e);
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExecutionException && t.getCause() instanceof CoreException) {
                CoreException cause = (CoreException)t.getCause();
                StatusAdapter status = cause.getStatus().getCode() == 275 ? new StatusAdapter(StatusUtil.newStatus((int)2, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)newProjectHandle.getName()), (Throwable)cause)) : new StatusAdapter(StatusUtil.newStatus((int)cause.getStatus().getSeverity(), (String)ResourceMessages.NewProject_errorMessage, (Throwable)cause));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)ResourceMessages.NewProject_errorMessage);
                StatusManager.getManager().handle(status, 4);
            } else {
                StatusAdapter status = new StatusAdapter((IStatus)new Status(2, "org.eclipse.ui.ide", 0, NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)t.getMessage()), t));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)ResourceMessages.NewProject_errorMessage);
                StatusManager.getManager().handle(status, 5);
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public boolean performFinish() {
        IProject p = this.createNewProject();
        try {
            AddRemoveNatureHandler.toggleNature(p);
        }
        catch (CoreException e1) {
            Logger.logError("Could not set Eulumdat Nature", e1);
            return false;
        }
        IRunnableWithProgress op = monitor -> {
            IFolder eulumdat = p.getFolder("eulumdat");
            try {
                eulumdat.create(true, true, monitor);
            }
            catch (CoreException e) {
                Logger.logError("Could not create folder '" + eulumdat.getName() + "'", e);
            }
            IFolder ies = p.getFolder("ies");
            try {
                ies.create(true, true, monitor);
            }
            catch (CoreException e) {
                Logger.logError("Could not create folder '" + ies.getName() + "'", e);
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InvocationTargetException e) {
            Logger.logError("Could not create folder 'eulumdat'", e);
        }
        catch (InterruptedException e) {
            Logger.logError("Operation cancelled", e);
            Thread.currentThread().interrupt();
        }
        try {
            Throwable e = null;
            Object var4_8 = null;
            try {
                InputStream ips = CreateConverterLampsHandler.createConverter(p);
                if (ips != null) {
                    ips.close();
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException | CoreException e) {
            Logger.logError("Could not create lamp converter", e);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage(PROJECTPAGE);
        this.mainPage.setTitle("Create an Eulumdat Tools Project");
        this.mainPage.setDescription("Create an Eulumdat Tools Project in workspace or external location.");
        this.addPage((IWizardPage)this.mainPage);
    }
}

