/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.wizards;

import com.fold1.data.EulumdatFactory;
import com.fold1.data.EulumdatRefactory;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.Ies;
import com.fold1.data.IesData;
import com.fold1.data.IesFactory;
import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.wizards.AbstractConversionWizard;
import com.fold1.exceptions.ConversionException;
import com.fold1.exceptions.ParserException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IImportWizard;

public final class ImportIesAsEulumdatWizard
extends AbstractConversionWizard
implements IImportWizard {
    private static final String SETTINGS = "IESimport";
    private final String testlabname;

    public ImportIesAsEulumdatWizard() {
        this.expander = Utils.IES;
        this.testlabname = EulumdatToolsPreferences.getStore().getString("TestlabName");
    }

    @Override
    protected String convert(IFile f, BufferedInputStream inputStream, Map<String, String> options) throws ConversionException {
        String converted;
        boolean rotate = Boolean.parseBoolean(options.get("rotate"));
        boolean swap = Boolean.parseBoolean(options.get("swap"));
        boolean testlab = Boolean.parseBoolean(options.get("testlab"));
        boolean testdate = Boolean.parseBoolean(options.get("testdate"));
        try {
            IesData ies = IesFactory.iesDataFromStream((InputStream)inputStream, (String)f.getName());
            if (!testdate) {
                ies.setDate(LocalDate.now().toString());
            }
            if (testlab) {
                System.setProperty("eulumdattools.user", this.testlabname);
            }
            IEulumdatRO ro = EulumdatFactory.eulumdatROFromIes((Ies)ies, (boolean)swap);
            if (rotate) {
                ro = EulumdatRefactory.unroll((IEulumdatRO)ro);
                ro = EulumdatRefactory.rotate90CW((IEulumdatRO)ro);
            }
            converted = ro.toString();
        }
        catch (ParserException e) {
            throw new ConversionException("Parser error in IES conversion", (Throwable)e);
        }
        catch (IOException e) {
            throw new ConversionException("IO error in IES conversion", (Throwable)e);
        }
        catch (Exception e) {
            throw new ConversionException("Unknown error in IES conversion", (Throwable)e);
        }
        return converted;
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".ldt";
    }

    @Override
    protected String getDestinationLabel() {
        return "EULUMDAT";
    }

    @Override
    protected Utils.Expander getExpander() {
        return this.expander;
    }

    @Override
    protected String getSettingsSectionName() {
        return SETTINGS;
    }

    @Override
    protected String getSourceLabel() {
        return "IES";
    }
}

