/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.wizards;

import com.fold1.data.Eulumdat2;
import com.fold1.data.EulumdatFactory;
import com.fold1.data.EulumdatRefactory;
import com.fold1.data.IEulumdatRO;
import com.fold1.data.IesFactory;
import com.fold1.eulumdat.tools.preferences.EulumdatToolsPreferences;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.wizards.AbstractConversionWizard;
import com.fold1.exceptions.ConversionException;
import com.fold1.exceptions.ParserException;
import com.fold1.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IImportWizard;

public class ImportEulumdatAsIesWizard
extends AbstractConversionWizard
implements IImportWizard {
    private static final String TESTDATE_RE = "\\[ISSUEDATE].*\\r?\\n";
    private static final String TESTLAB_RE = "\\[TESTLAB].*\\r?\\n";
    private static final String SETTINGS = "EULUMDATimport";
    private final String testlabname;

    public ImportEulumdatAsIesWizard() {
        this.expander = Utils.EULUMDAT;
        this.testlabname = EulumdatToolsPreferences.getStore().getString("TestlabName");
    }

    @Override
    protected String convert(IFile f, BufferedInputStream inputStream, Map<String, String> options) throws ConversionException {
        Eulumdat2 ro;
        boolean rotate = Boolean.parseBoolean(options.get("rotate"));
        boolean swap = Boolean.parseBoolean(options.get("swap"));
        boolean testlab = Boolean.parseBoolean(options.get("testlab"));
        boolean testdate = Boolean.parseBoolean(options.get("testdate"));
        try {
            ro = EulumdatFactory.eulumdatFromInputStream((InputStream)inputStream, (String)f.getName());
        }
        catch (ParserException e) {
            throw new ConversionException("Parser error in IES conversion", (Throwable)e);
        }
        catch (IOException e) {
            throw new ConversionException("IO error in IES conversion", (Throwable)e);
        }
        catch (Exception e) {
            throw new ConversionException("Unknown error in IES conversion", (Throwable)e);
        }
        if (rotate) {
            ro = EulumdatRefactory.unroll((IEulumdatRO)ro);
            ro = EulumdatRefactory.rotate90CCW((IEulumdatRO)ro);
        }
        String converted = IesFactory.iesFromEulumdat((IEulumdatRO)ro, (int)0, (boolean)swap);
        if (testdate) {
            converted = converted.replaceAll(TESTDATE_RE, "[ISSUEDATE] " + StringUtils.unquote((String)ro.getDateUser()) + "\n");
        }
        if (testlab) {
            converted = converted.replaceAll(TESTLAB_RE, "[TESTLAB] " + this.testlabname + "\n");
        }
        return converted;
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".ies";
    }

    @Override
    protected String getDestinationLabel() {
        return "IES";
    }

    @Override
    protected Utils.Expander getExpander() {
        return this.expander;
    }

    @Override
    protected String getSettingsSectionName() {
        return SETTINGS;
    }

    @Override
    protected String getSourceLabel() {
        return "EULUMDAT";
    }
}

