/*
 * Decompiled with CFR 0.152.
 */
package com.fold1.eulumdat.tools.wizards;

import com.fold1.eulumdat.tools.preferences.RegistrationController;
import com.fold1.eulumdat.tools.utils.Utils;
import com.fold1.eulumdat.tools.wizards.AbstractDestinationPage;
import com.fold1.eulumdat.tools.wizards.ContainerChooserComposite;
import com.fold1.eulumdat.tools.wizards.ConversionOptionsComposite;
import com.fold1.eulumdat.tools.wizards.ExpandedFilelistComposite;
import com.fold1.eulumdat.tools.wizards.WizardPageOkChecker;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ImportDestinationPage
extends AbstractDestinationPage
implements WizardPageOkChecker {
    public static final String ROTATE = "rotate";
    public static final String SWAP = "swap";
    public static final String TESTLAB = "testlab";
    public static final String TESTDATE = "testdate";
    private final IStructuredSelection initialSelection;
    private final Utils.Expander filter;
    private ConversionOptionsComposite conversionOptionsComposite;

    protected ImportDestinationPage(String pageName, IStructuredSelection initialSelection, Utils.Expander filter) {
        super(pageName);
        this.initialSelection = initialSelection;
        this.filter = filter;
        this.setTitle(pageName);
        StringBuilder sb = new StringBuilder();
        sb.append("Check the selected files and choose the output destination.");
        if (!RegistrationController.isValidFullLicense(false)) {
            sb.append("\nEVAL or UNLICENSED users have conversions limited to max ");
            sb.append(5);
            sb.append(" operations at a time");
        }
        this.setDescription(sb.toString());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FormLayout());
        FormData containerData = new FormData();
        containerData.width = 1000;
        container.setLayoutData((Object)containerData);
        this.sourceStore = new ContainerChooserComposite(container, 0, false);
        this.sourceStore.setLayoutData(new FormData());
        this.sourceStore.setBrowseMessage("Select container with the files to convert");
        FormData source = new FormData();
        source.top = new FormAttachment(0, 0);
        source.left = new FormAttachment(0, 0);
        source.right = new FormAttachment(100, 0);
        source.bottom = new FormAttachment(0, 50);
        this.sourceStore.setLayoutData(source);
        this.sourceStore.setTargetLabelText("Import from:");
        this.sourceStore.setInitialContainer(ImportDestinationPage.validContainerFromSelection(this.initialSelection));
        this.sourceStore.addModifyListener(e -> {
            String path = this.sourceStore.getTargetStorePathText();
            try {
                this.selection = Utils.expandSelection(path, this.filter);
                this.expandedFilelistComposite.setSelection(this.selection);
            }
            catch (CoreException exception) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"File List Expansion Error", (String)exception.getMessage(), (IStatus)exception.getStatus());
            }
        });
        this.destinationStore = new ContainerChooserComposite(container, 0, true);
        this.destinationStore.setLayoutData(new FormData());
        this.destinationStore.setBrowseMessage("Select container to store the converted files");
        FormData store = new FormData();
        store.top = new FormAttachment(100, -50);
        store.left = new FormAttachment(0, 0);
        store.right = new FormAttachment(100, 0);
        store.bottom = new FormAttachment(100, 0);
        this.destinationStore.setLayoutData(store);
        this.destinationStore.setTargetLabelText("Save in:");
        this.destinationStore.setInitialContainer(ImportDestinationPage.validContainerFromSelection(this.initialSelection));
        this.expandedFilelistComposite = new ExpandedFilelistComposite(container, 0);
        this.expandedFilelistComposite.setLayoutData(new FormData());
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.sourceStore, 16, 1024);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.expandedFilelistComposite.setLayoutData(data);
        this.expandedFilelistComposite.setChecker(this);
        this.expandedFilelistComposite.setSelection(this.selection);
        this.conversionOptionsComposite = new ConversionOptionsComposite(container, 0);
        FormData options = new FormData();
        options.top = new FormAttachment((Control)this.expandedFilelistComposite);
        options.left = new FormAttachment(0, 0);
        options.right = new FormAttachment(100, 0);
        options.bottom = new FormAttachment((Control)this.destinationStore, -16, 128);
        this.conversionOptionsComposite.setLayoutData(options);
        this.sourceStore.setChecker(this);
        this.destinationStore.setChecker(this);
        this.restoreWidgetValues();
        this.okToComplete();
        this.setControl((Control)container);
    }

    @Override
    protected Map<String, String> getOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(SWAP, this.conversionOptionsComposite.getSwapWidthLength().toString());
        options.put(ROTATE, this.conversionOptionsComposite.getRotateLdc().toString());
        options.put(TESTLAB, this.conversionOptionsComposite.getCopyTestLab().toString());
        options.put(TESTDATE, this.conversionOptionsComposite.getCopyTestDate().toString());
        return options;
    }
}

